/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.FunctionEntry;
import ghidra.features.bsim.query.protocol.ResponseChildren;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class QueryChildren
extends BSimQuery<ResponseChildren> {
    public String md5sum = null;
    public String name_exec = null;
    public String arch = null;
    public String name_compiler = null;
    public List<FunctionEntry> functionKeys = new ArrayList<FunctionEntry>();
    public ResponseChildren childrenresponse = null;

    public QueryChildren() {
        super("querychildren");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.childrenresponse = new ResponseChildren(this);
            this.response = this.childrenresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        if (this.md5sum != null && this.md5sum.length() != 0) {
            fwrite.append("  <md5>").append(this.md5sum).append("</md5>\n");
        } else {
            fwrite.append("  <name>");
            if (this.name_exec != null) {
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.name_exec);
            }
            fwrite.append("</name>\n");
            fwrite.append("  <arch>");
            if (this.arch != null) {
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.arch);
            }
            fwrite.append("</arch>\n");
            fwrite.append("  <compiler>");
            if (this.name_compiler != null) {
                SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.name_compiler);
            }
            fwrite.append("</compiler>\n");
        }
        for (int i = 0; i < this.functionKeys.size(); ++i) {
            this.functionKeys.get(i).saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        XmlElement el = parser.start(new String[0]);
        if (el.getName().equals("md5")) {
            this.md5sum = parser.end().getText();
            this.name_exec = null;
            this.arch = null;
            this.name_compiler = null;
        } else {
            this.md5sum = null;
            this.name_exec = parser.end().getText();
            parser.start(new String[]{"arch"});
            this.arch = parser.end().getText();
            parser.start(new String[]{"compiler"});
            this.name_compiler = parser.end().getText();
        }
        while (parser.peek().isStart()) {
            FunctionEntry functionKey = FunctionEntry.restoreXml(parser);
            this.functionKeys.add(functionKey);
        }
        parser.end();
    }
}

