/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.features.codecompare.functiongraph.FgComparisonContext;
import ghidra.features.codecompare.functiongraph.FgDisplay;
import ghidra.features.codecompare.functiongraph.FunctionGraphCodeComparisonView;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Duo;

public class FgChooseFormatAction
extends DockingAction {
    private FunctionGraphCodeComparisonView fgProvider;

    public FgChooseFormatAction(FunctionGraphCodeComparisonView fgProvider) {
        super("Edit Code Block Fields", fgProvider.getOwner());
        this.fgProvider = fgProvider;
        this.setPopupMenuData(new MenuData(new String[]{"Edit Fields"}));
        this.setHelpLocation(new HelpLocation("FunctionGraphPlugin", "Function_Graph_Action_Format"));
    }

    public void actionPerformed(ActionContext context) {
        Duo<FgDisplay> displays = this.fgProvider.getDisplays();
        FgDisplay leftDisplay = (FgDisplay)displays.get(Duo.Side.LEFT);
        FGController leftController = leftDisplay.getController();
        leftController.showFormatChooser();
        FormatManager leftFormatManager = leftController.getMinimalFormatManager();
        FgDisplay rightDisplay = (FgDisplay)displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        rightController.updateMinimalFormatManager(leftFormatManager);
        this.fgProvider.stateChanged();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof FgComparisonContext)) {
            return false;
        }
        Duo<FgDisplay> displays = this.fgProvider.getDisplays();
        FgDisplay leftDisplay = (FgDisplay)displays.get(Duo.Side.LEFT);
        FGController controller = leftDisplay.getController();
        return controller.hasResults();
    }
}

