/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.action.DockingAction;
import java.awt.KeyboardFocusManager;
import javax.swing.KeyStroke;

public class GlobalFocusTraversalAction
extends DockingAction {
    private static final String GLOBAL_FOCUS_TRAVERSAL_PROPERTY = "docking.global.focus.traversal.key.enabled";
    private boolean forward;

    public GlobalFocusTraversalAction(KeyStroke keybinding, boolean forward) {
        super(forward ? "Next Component" : "Previous Component", "DockingWindows");
        this.forward = forward;
        this.createSystemKeyBinding(keybinding);
        this.setEnabled(GlobalFocusTraversalAction.isGlobalFocusTraversalEnabled());
    }

    @Override
    public void actionPerformed(ActionContext context) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (this.forward) {
            focusManager.focusNextComponent();
        } else {
            focusManager.focusPreviousComponent();
        }
    }

    private static boolean isGlobalFocusTraversalEnabled() {
        String property = System.getProperty(GLOBAL_FOCUS_TRAVERSAL_PROPERTY, Boolean.TRUE.toString());
        return Boolean.parseBoolean(property);
    }
}

