/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DisplayStringProvider;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableRowMapper;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraintProvider;
import docking.widgets.table.constraint.ColumnTypeMapper;
import docking.widgets.table.constraint.EnumColumnConstraint;
import docking.widgets.table.constraint.MappedColumnConstraint;
import docking.widgets.table.constraint.ObjectToStringMapper;
import ghidra.util.classfinder.ClassSearcher;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import utilities.util.reflection.ReflectionUtilities;

public class DiscoverableTableUtils {
    private static List<ColumnConstraint<?>> columnConstraints;

    public static <ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> DynamicTableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> adaptColumForModel(GDynamicColumnTableModel<ROW_TYPE, COLUMN_TYPE> model, AbstractDynamicTableColumn<?, ?, ?> column) {
        List columnTypeArguments;
        Class columnRowClass;
        Class<?> implementationClass = model.getClass();
        List modelTypeArguments = ReflectionUtilities.getTypeArguments(GDynamicColumnTableModel.class, implementationClass);
        Class tableRowClass = (Class)modelTypeArguments.get(0);
        if (tableRowClass == (columnRowClass = (Class)(columnTypeArguments = ReflectionUtilities.getTypeArguments(AbstractDynamicTableColumn.class, column.getClass())).get(0))) {
            return column;
        }
        Collection columns = DiscoverableTableUtils.getTableColumnForTypes(tableRowClass, column);
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Do not know how to map column to model for types: " + String.valueOf(columnRowClass) + " and " + String.valueOf(tableRowClass));
        }
        return columns.iterator().next();
    }

    public static <ROW_TYPE> Collection<DynamicTableColumn<ROW_TYPE, ?, ?>> getDynamicTableColumns(Class<ROW_TYPE> rowTypeClass) {
        Collection<DynamicTableColumn<?, ?, ?>> columnExtensions = DiscoverableTableUtils.getTableColumExtensions();
        HashSet dataSet = new HashSet();
        for (DynamicTableColumn<?, ?, ?> column : columnExtensions) {
            Collection mappedColumns = DiscoverableTableUtils.getTableColumnForTypes(rowTypeClass, column);
            dataSet.addAll(mappedColumns);
        }
        return dataSet;
    }

    private static Collection<DynamicTableColumn<?, ?, ?>> getTableColumExtensions() {
        ArrayList list = new ArrayList();
        for (DynamicTableColumn dynamicTableColumn : ClassSearcher.getInstances(DynamicTableColumn.class)) {
            list.add(dynamicTableColumn);
        }
        return list;
    }

    private static <COLUMN_ROW_TYPE, TABLE_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE> Collection<DynamicTableColumn<TABLE_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>> getTableColumnForTypes(Class<TABLE_ROW_TYPE> rowTypeClass, DynamicTableColumn<?, ?, ?> tableColumn) {
        HashSet<DynamicTableColumn<TABLE_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>> set = new HashSet<DynamicTableColumn<TABLE_ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>>();
        Class<?> supportedRowType = tableColumn.getSupportedRowType();
        if (supportedRowType == rowTypeClass) {
            set.add(tableColumn);
            return set;
        }
        Collection mappers = DiscoverableTableUtils.getTableRowObjectMapper(rowTypeClass, supportedRowType);
        if (mappers.isEmpty()) {
            return Collections.emptySet();
        }
        DynamicTableColumn<?, ?, ?> castColumn = tableColumn;
        return DiscoverableTableUtils.createMappedTableColumn(mappers, castColumn);
    }

    private static <ROW_TYPE, EXPECTED_TYPE, DATA_SOURCE> Collection<TableRowMapper<ROW_TYPE, EXPECTED_TYPE, DATA_SOURCE>> getTableRowObjectMapper(Class<ROW_TYPE> fromType, Class<?> toType) {
        HashSet<TableRowMapper<ROW_TYPE, EXPECTED_TYPE, DATA_SOURCE>> set = new HashSet<TableRowMapper<ROW_TYPE, EXPECTED_TYPE, DATA_SOURCE>>();
        List instances = ClassSearcher.getInstances(TableRowMapper.class);
        for (TableRowMapper mapper : instances) {
            if (mapper.getSourceType() != fromType || mapper.getDestinationType() != toType) continue;
            set.add(mapper);
        }
        return set;
    }

    private static <ROW_TYPE, EXPECTED_TYPE, COLUMN_TYPE, DATA_SOURCE> Collection<DynamicTableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>> createMappedTableColumn(Collection<TableRowMapper<ROW_TYPE, EXPECTED_TYPE, DATA_SOURCE>> mappers, DynamicTableColumn<EXPECTED_TYPE, COLUMN_TYPE, DATA_SOURCE> wrappedColumn) {
        HashSet<DynamicTableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>> set = new HashSet<DynamicTableColumn<ROW_TYPE, COLUMN_TYPE, DATA_SOURCE>>();
        for (TableRowMapper<ROW_TYPE, EXPECTED_TYPE, DATA_SOURCE> mapper : mappers) {
            set.add(mapper.createMappedTableColumn(wrappedColumn));
        }
        return set;
    }

    public static <T, M> Collection<ColumnConstraint<T>> getColumnConstraints(ColumnTypeMapper<T, M> mapper) {
        Class<M> destinationType = mapper.getDestinationType();
        Collection<ColumnConstraint<M>> unmapped = DiscoverableTableUtils.getColumnConstraints(destinationType);
        Collection<ColumnConstraint<T>> mapped = DiscoverableTableUtils.mapConstraints(mapper, unmapped);
        return mapped;
    }

    public static <T> Collection<ColumnConstraint<T>> getColumnConstraints(Class<T> columnType) {
        ArrayList<ColumnConstraint<T>> list = new ArrayList<ColumnConstraint<T>>();
        if (columnType.isEnum()) {
            list.add(new EnumColumnConstraint<T>(columnType, Collections.emptySet()));
            return list;
        }
        DiscoverableTableUtils.initializeColumnConstraints();
        for (ColumnConstraint<?> constraint : columnConstraints) {
            if (!constraint.getColumnType().isAssignableFrom(columnType)) continue;
            list.add(constraint);
        }
        if (list.isEmpty() && DiscoverableTableUtils.hasGoodStringConversion(columnType)) {
            list.addAll(DiscoverableTableUtils.wrapToStringConstraints(columnType, DiscoverableTableUtils.getColumnConstraints(String.class)));
        }
        Collections.sort(list);
        return list;
    }

    private static void initializeColumnConstraints() {
        if (columnConstraints != null) {
            return;
        }
        List<ColumnConstraint<?>> foundConstraints = DiscoverableTableUtils.findColumnConstraints();
        ArrayList mappedConstraints = new ArrayList();
        List mappers = ClassSearcher.getInstances(ColumnTypeMapper.class);
        for (ColumnTypeMapper mapper : mappers) {
            mappedConstraints.addAll(DiscoverableTableUtils.generateMappedConstraints(mapper, foundConstraints));
        }
        foundConstraints.addAll(mappedConstraints);
        columnConstraints = foundConstraints;
    }

    private static <T, M> Collection<ColumnConstraint<?>> generateMappedConstraints(ColumnTypeMapper<T, M> mapper, List<ColumnConstraint<?>> foundConstraints) {
        ArrayList mappedConstraints = new ArrayList();
        Class<M> destinationType = mapper.getDestinationType();
        List<ColumnConstraint<M>> list = DiscoverableTableUtils.getMatchingConstraints(foundConstraints, destinationType);
        for (ColumnConstraint<M> columnConstraint : list) {
            MappedColumnConstraint<T, M> mappedConstraint = new MappedColumnConstraint<T, M>(mapper, columnConstraint);
            mappedConstraints.add(mappedConstraint);
        }
        return mappedConstraints;
    }

    private static <T, M> Collection<ColumnConstraint<T>> mapConstraints(ColumnTypeMapper<T, M> mapper, Collection<ColumnConstraint<M>> constraints) {
        ArrayList<ColumnConstraint<T>> mappedConstraints = new ArrayList<ColumnConstraint<T>>();
        for (ColumnConstraint<M> columnConstraint : constraints) {
            MappedColumnConstraint<T, M> mappedConstraint = new MappedColumnConstraint<T, M>(mapper, columnConstraint);
            mappedConstraints.add(mappedConstraint);
        }
        return mappedConstraints;
    }

    private static <T> List<ColumnConstraint<T>> getMatchingConstraints(List<ColumnConstraint<?>> constraints, Class<T> destinationType) {
        ArrayList<ColumnConstraint<T>> list = new ArrayList<ColumnConstraint<T>>();
        for (ColumnConstraint<?> columnConstraint : constraints) {
            if (!columnConstraint.getColumnType().equals(destinationType)) continue;
            list.add(columnConstraint);
        }
        return list;
    }

    private static boolean hasGoodStringConversion(Class<?> columnType) {
        if (DisplayStringProvider.class.isAssignableFrom(columnType)) {
            return true;
        }
        try {
            Method method = columnType.getMethod("toString", new Class[0]);
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
        return true;
    }

    private static <T> List<ColumnConstraint<T>> wrapToStringConstraints(Class<T> type, Collection<ColumnConstraint<String>> stringConstraints) {
        ArrayList<ColumnConstraint<T>> list = new ArrayList<ColumnConstraint<T>>();
        for (ColumnConstraint<String> constraint : stringConstraints) {
            list.add(new MappedColumnConstraint(new ObjectToStringMapper<T>(type), constraint));
        }
        return list;
    }

    private static List<ColumnConstraint<?>> findColumnConstraints() {
        ArrayList constraints = new ArrayList();
        List constraintProviders = ClassSearcher.getInstances(ColumnConstraintProvider.class);
        for (ColumnConstraintProvider provider : constraintProviders) {
            constraints.addAll(provider.getColumnConstraints());
        }
        return constraints;
    }
}

