/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.FontModifier;
import generic.theme.GThemeValueMap;
import generic.theme.ThemeManager;
import generic.theme.ThemeValue;
import ghidra.util.Msg;
import java.awt.Font;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;

public class FontValue
extends ThemeValue<Font> {
    public static final String LAF_ID_PREFIX = "laf.font.";
    public static final String EXTERNAL_LAF_ID_PREFIX = "[laf.font]";
    static final String FONT_ID_PREFIX = "font.";
    private static final String EXTERNAL_PREFIX = "[font]";
    public static final Font LAST_RESORT_DEFAULT = new Font("monospaced", 0, 12);
    private FontModifier modifier;

    public FontValue(String id, Font value) {
        super(id, null, value);
    }

    public FontValue(String id, String refId) {
        super(id, refId, null);
    }

    private FontValue(String id, String refId, FontModifier modifier) {
        super(id, refId, null);
        this.modifier = modifier;
    }

    @Override
    public String getSerializationString() {
        String outputId = FontValue.toExternalId(this.id);
        return outputId + " = " + this.getValueOutput();
    }

    @Override
    public boolean isExternal() {
        return !this.id.startsWith(FONT_ID_PREFIX);
    }

    @Override
    public Font get(GThemeValueMap values) {
        Font font = (Font)super.get(values);
        if (this.modifier != null) {
            return this.modifier.modify(font);
        }
        return font;
    }

    private String getValueOutput() {
        if (this.referenceId != null) {
            String refId = FontValue.toExternalId(this.referenceId);
            if (this.modifier != null) {
                return refId + this.modifier.getSerializationString();
            }
            return refId;
        }
        return FontValue.fontToString((Font)this.value);
    }

    public static String fontToString(Font font) {
        return String.format("%s-%s-%s", font.getName(), FontValue.getStyleString(font), font.getSize());
    }

    public static boolean isFontKey(String key) {
        return StringUtils.startsWithAny((CharSequence)key, (CharSequence[])new CharSequence[]{FONT_ID_PREFIX, EXTERNAL_PREFIX, EXTERNAL_LAF_ID_PREFIX});
    }

    public static FontValue parse(String key, String value) throws ParseException {
        String id = FontValue.fromExternalId(key);
        if (FontValue.isFontKey(value = FontValue.clean(value))) {
            return FontValue.getRefFontValue(id, value);
        }
        Font font = FontValue.parseFont(value);
        return font == null ? null : new FontValue(id, font);
    }

    public static int getStyle(String styleString) {
        if ("plain".equalsIgnoreCase(styleString)) {
            return 0;
        }
        if ("bold".equalsIgnoreCase(styleString)) {
            return 1;
        }
        if ("italic".equalsIgnoreCase(styleString)) {
            return 2;
        }
        if ("bolditalic".equalsIgnoreCase(styleString)) {
            return 3;
        }
        return -1;
    }

    protected FontValue getReferredValue(GThemeValueMap values, String refId) {
        return values.getFont(refId);
    }

    @Override
    protected Font getUnresolvedReferenceValue(String primaryId, String unresolvedId) {
        Msg.warn((Object)this, (Object)("Could not resolve indirect font path for \"" + unresolvedId + "\" for primary id \"" + primaryId + "\", using last resort default"));
        return LAST_RESORT_DEFAULT;
    }

    public FontModifier getModifier() {
        return this.modifier;
    }

    private static String toExternalId(String internalId) {
        if (internalId.startsWith(FONT_ID_PREFIX)) {
            return internalId;
        }
        if (internalId.startsWith(LAF_ID_PREFIX)) {
            String baseId = internalId.substring(LAF_ID_PREFIX.length());
            return EXTERNAL_LAF_ID_PREFIX + baseId;
        }
        return EXTERNAL_PREFIX + internalId;
    }

    private static String fromExternalId(String externalId) {
        if (externalId.startsWith(EXTERNAL_PREFIX)) {
            return externalId.substring(EXTERNAL_PREFIX.length());
        }
        if (externalId.startsWith(EXTERNAL_LAF_ID_PREFIX)) {
            return LAF_ID_PREFIX + externalId.substring(EXTERNAL_LAF_ID_PREFIX.length());
        }
        return externalId;
    }

    private static Font parseFont(String value) {
        int sizeIndex = value.lastIndexOf("-");
        int styleIndex = value.lastIndexOf("-", sizeIndex - 1);
        if (sizeIndex <= 0 || styleIndex <= 0) {
            return null;
        }
        String sizeString = value.substring(sizeIndex + 1);
        String styleString = value.substring(styleIndex + 1, sizeIndex);
        String familyName = value.substring(0, styleIndex);
        try {
            int size = Integer.parseInt(sizeString);
            int style = FontValue.getStyle(styleString);
            if (style >= 0) {
                return new Font(familyName, style, size);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static FontValue getRefFontValue(String id, String value) throws ParseException {
        int modIndex = (value = FontValue.fromExternalId(value)).indexOf("[");
        if (modIndex < 0) {
            return new FontValue(id, FontValue.fromExternalId(value));
        }
        String refId = value.substring(0, modIndex).trim();
        FontModifier modifier = FontModifier.parse(value.substring(modIndex));
        return new FontValue(id, refId, modifier);
    }

    private static String clean(String value) {
        if ((value = value.trim()).startsWith("(")) {
            value = value.substring(1);
        }
        if (value.endsWith(")")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private static String getStyleString(Font font) {
        boolean bold = font.isBold();
        boolean italic = font.isItalic();
        if (bold && italic) {
            return "BOLDITALIC";
        }
        if (bold) {
            return "BOLD";
        }
        if (italic) {
            return "ITALIC";
        }
        return "PLAIN";
    }

    @Override
    public void installValue(ThemeManager themeManager) {
        themeManager.setFont(this);
    }
}

