/*
 * Decompiled with CFR 0.152.
 */
package resources.icons;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class RotateIcon
implements Icon {
    private final Icon icon;
    private final int degrees;
    private String description;

    public RotateIcon(Icon icon, int degrees) {
        this.icon = icon;
        this.degrees = degrees;
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        int height = this.getIconHeight();
        int width = this.getIconWidth();
        int rotX = x + (width >> 1);
        int rotY = y + (height >> 1);
        g2.rotate(Math.toRadians(this.degrees), rotX, rotY);
        this.icon.paintIcon(c, g, x, y);
        g2.rotate(-Math.toRadians(this.degrees), rotX, rotY);
    }

    public String toString() {
        if (this.description == null) {
            this.description = this.icon.toString();
        }
        return this.description;
    }

    public Icon getSourceIcon() {
        return this.icon;
    }

    public int getRotation() {
        return this.degrees;
    }
}

