/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.layout;

import java.util.Objects;

public class GridRange {
    public int min;
    public int max;

    public GridRange() {
        this(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public GridRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public void add(int value) {
        this.min = Math.min(value, this.min);
        this.max = Math.max(value, this.max);
    }

    public String toString() {
        return "[" + this.min + " -> " + this.max + "]";
    }

    public boolean isEmpty() {
        return this.min > this.max;
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridRange other = (GridRange)obj;
        return this.max == other.max && this.min == other.min;
    }

    public int width() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.max - this.min + 1;
    }
}

