/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.model.config.v4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u0001\u000eB\u0011\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0000H\u0096\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u0004H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/fus/reporting/model/config/v4/ConfigurationMajorVersion;", "", "components", "", "", "([I)V", "getComponents", "()[I", "compareTo", "other", "equals", "", "", "hashCode", "Companion", "model"})
public final class ConfigurationMajorVersion
implements Comparable<ConfigurationMajorVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] components;
    private static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    private static final char SEPARATOR = '.';

    public ConfigurationMajorVersion(int ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.components = components;
    }

    @NotNull
    public final int[] getComponents() {
        return this.components;
    }

    @Override
    public int compareTo(@Nullable ConfigurationMajorVersion other) {
        if (other == null) {
            return 1;
        }
        int[] c1 = this.components;
        int[] c2 = other.components;
        int n = Math.min(c1.length, c2.length);
        for (int i2 = 0; i2 < n; ++i2) {
            if (c1[i2] == c2[i2] && c1[i2] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i2] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i2] == Integer.MAX_VALUE) {
                return -1;
            }
            int result2 = c1[i2] - c2[i2];
            if (result2 == 0) continue;
            return result2;
        }
        return c1.length - c2.length;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        ConfigurationMajorVersion number = (ConfigurationMajorVersion)other;
        return Arrays.equals(this.components, number.components);
    }

    public int hashCode() {
        return Arrays.hashCode(this.components);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/model/config/v4/ConfigurationMajorVersion$Companion;", "", "()V", "SEPARATOR", "", "SNAPSHOT_VALUE", "", "fromString", "Lcom/jetbrains/fus/reporting/model/config/v4/ConfigurationMajorVersion;", "version", "", "isEmptyOrSpaces", "", "s", "split", "", "text", "toIntArray", "", "components", "tryParseInt", "model"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ConfigurationMajorVersion fromString(@Nullable String version) {
            if (version == null || this.isEmptyOrSpaces(version)) {
                return null;
            }
            int separator = StringsKt.indexOf$default((CharSequence)version, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (separator > 0) {
                List<String> components = this.split(version);
                int[] nArray = this.toIntArray(components);
                return new ConfigurationMajorVersion(Arrays.copyOf(nArray, nArray.length));
            }
            int[] nArray = new int[]{this.tryParseInt(version), 0};
            return new ConfigurationMajorVersion(nArray);
        }

        private final int[] toIntArray(List<String> components) {
            int componentsSize = components.size();
            int size = componentsSize != 1 ? componentsSize : 2;
            int[] array = new int[size];
            for (int i2 = 0; i2 < componentsSize; ++i2) {
                String component = components.get(i2);
                array[i2] = this.tryParseInt(component);
            }
            if (componentsSize < size) {
                array[componentsSize] = 0;
            }
            return array;
        }

        private final int tryParseInt(String version) {
            int n;
            try {
                n = Integer.parseInt(version);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            return n;
        }

        private final boolean isEmptyOrSpaces(String s) {
            CharSequence charSequence = s;
            if (charSequence == null || charSequence.length() == 0) {
                return true;
            }
            for (int j = 0; j < s.length(); ++j) {
                char element = s.charAt(j);
                if (Intrinsics.compare((int)element, (int)32) <= 0) continue;
                return false;
            }
            return true;
        }

        private final List<String> split(String text) {
            List result2 = new ArrayList();
            int pos = 0;
            int index = StringsKt.indexOf$default((CharSequence)text, (char)'.', (int)pos, (boolean)false, (int)4, null);
            while (index >= 0) {
                String token;
                int nextPos = index + 1;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(pos, index), (String)"substring(...)");
                if (((CharSequence)token).length() > 0) {
                    result2.add(token);
                }
                pos = nextPos;
                index = StringsKt.indexOf$default((CharSequence)text, (char)'.', (int)pos, (boolean)false, (int)4, null);
            }
            if (pos < text.length()) {
                String string2 = text.substring(pos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                result2.add(string2);
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

