/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryConfig;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.VersionedKeyValueStore;
import org.apache.kafka.streams.state.VersionedRecord;

public class KeyValueStoreWrapper<K, V>
implements StateStore {
    public static final long PUT_RETURN_CODE_IS_LATEST = -1L;
    private TimestampedKeyValueStore<K, V> timestampedStore = null;
    private VersionedKeyValueStore<K, V> versionedStore = null;
    private StateStore store;

    public KeyValueStoreWrapper(ProcessorContext<?, ?> context, String storeName) {
        try {
            this.timestampedStore = (TimestampedKeyValueStore)context.getStateStore(storeName);
            this.store = this.timestampedStore;
            return;
        }
        catch (ClassCastException classCastException) {
            try {
                this.versionedStore = (VersionedKeyValueStore)context.getStateStore(storeName);
                this.store = this.versionedStore;
            }
            catch (ClassCastException e) {
                this.store = context.getStateStore(storeName);
                String storeType = this.store == null ? "null" : this.store.getClass().getName();
                throw new InvalidStateStoreException("KTable source state store must implement either TimestampedKeyValueStore or VersionedKeyValueStore. Got: " + storeType);
            }
            return;
        }
    }

    public ValueAndTimestamp<V> get(K key) {
        if (this.timestampedStore != null) {
            return (ValueAndTimestamp)this.timestampedStore.get(key);
        }
        if (this.versionedStore != null) {
            VersionedRecord<V> versionedRecord = this.versionedStore.get(key);
            return versionedRecord == null ? null : ValueAndTimestamp.make(versionedRecord.value(), versionedRecord.timestamp());
        }
        throw new IllegalStateException("KeyValueStoreWrapper must be initialized with either timestamped or versioned store");
    }

    public ValueAndTimestamp<V> get(K key, long asOfTimestamp) {
        if (!this.isVersionedStore()) {
            throw new UnsupportedOperationException("get(key, timestamp) is only supported for versioned stores");
        }
        VersionedRecord<V> versionedRecord = this.versionedStore.get(key, asOfTimestamp);
        return versionedRecord == null ? null : ValueAndTimestamp.make(versionedRecord.value(), versionedRecord.timestamp());
    }

    public long put(K key, V value, long timestamp) {
        if (this.timestampedStore != null) {
            this.timestampedStore.put(key, ValueAndTimestamp.make(value, timestamp));
            return -1L;
        }
        if (this.versionedStore != null) {
            return this.versionedStore.put(key, value, timestamp);
        }
        throw new IllegalStateException("KeyValueStoreWrapper must be initialized with either timestamped or versioned store");
    }

    public StateStore store() {
        return this.store;
    }

    public boolean isVersionedStore() {
        return this.versionedStore != null;
    }

    @Override
    public String name() {
        return this.store.name();
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        this.store.init(stateStoreContext, root);
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public boolean persistent() {
        return this.store.persistent();
    }

    @Override
    public boolean isOpen() {
        return this.store.isOpen();
    }

    @Override
    public <R> QueryResult<R> query(Query<R> query, PositionBound positionBound, QueryConfig config) {
        return this.store.query(query, positionBound, config);
    }

    @Override
    public Position getPosition() {
        return this.store.getPosition();
    }
}

