/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.security.Provider;
import java.security.Security;

public class Environment {
    public static final boolean IS_IBM_JAVA = System.getProperty("java.vendor").contains("IBM");
    public static final int DEFAULT_JBOSS_AS_STARTUP_TIMEOUT = 300;
    public static final String PROFILE = "kc.profile";
    public static final String ENV_PROFILE = "KC_PROFILE";
    public static final String DEV_PROFILE_VALUE = "dev";

    public static int getServerStartupTimeout() {
        String timeout = System.getProperty("jboss.as.management.blocking.timeout");
        if (timeout != null) {
            return Integer.parseInt(timeout);
        }
        return 300;
    }

    public static boolean isJavaInFipsMode() {
        String property = System.getProperty("com.redhat.fips");
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        for (Provider provider : Security.getProviders()) {
            if (provider.getName().equals("BCFIPS") || !provider.getName().toUpperCase().contains("FIPS")) continue;
            return true;
        }
        return false;
    }

    public static boolean isDevMode() {
        return DEV_PROFILE_VALUE.equalsIgnoreCase(Environment.getProfile());
    }

    public static String getProfile() {
        String profile = System.getProperty(PROFILE);
        if (profile != null) {
            return profile;
        }
        return System.getenv(ENV_PROFILE);
    }
}

