/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NodeDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="ip")
    private final String ip;
    @JsonProperty(value="vipHostname")
    private final String vipHostname;
    @JsonProperty(value="vip")
    private final String vip;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="dbServerId")
    private final String dbServerId;

    @Deprecated
    @ConstructorProperties(value={"hostname", "ip", "vipHostname", "vip", "lifecycleState", "dbServerId"})
    public NodeDetails(String hostname, String ip, String vipHostname, String vip, LifecycleState lifecycleState, String dbServerId) {
        this.hostname = hostname;
        this.ip = ip;
        this.vipHostname = vipHostname;
        this.vip = vip;
        this.lifecycleState = lifecycleState;
        this.dbServerId = dbServerId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp() {
        return this.ip;
    }

    public String getVipHostname() {
        return this.vipHostname;
    }

    public String getVip() {
        return this.vip;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDbServerId() {
        return this.dbServerId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NodeDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hostname=").append(String.valueOf(this.hostname));
        sb.append(", ip=").append(String.valueOf(this.ip));
        sb.append(", vipHostname=").append(String.valueOf(this.vipHostname));
        sb.append(", vip=").append(String.valueOf(this.vip));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", dbServerId=").append(String.valueOf(this.dbServerId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeDetails)) {
            return false;
        }
        NodeDetails other = (NodeDetails)((Object)o);
        return Objects.equals(this.hostname, other.hostname) && Objects.equals(this.ip, other.ip) && Objects.equals(this.vipHostname, other.vipHostname) && Objects.equals(this.vip, other.vip) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.dbServerId, other.dbServerId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.ip == null ? 43 : this.ip.hashCode());
        result = result * 59 + (this.vipHostname == null ? 43 : this.vipHostname.hashCode());
        result = result * 59 + (this.vip == null ? 43 : this.vip.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.dbServerId == null ? 43 : this.dbServerId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        RequiresValidation("REQUIRES_VALIDATION"),
        Validating("VALIDATING"),
        Validated("VALIDATED"),
        ValidationFailed("VALIDATION_FAILED"),
        Updating("UPDATING"),
        Allocated("ALLOCATED"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="ip")
        private String ip;
        @JsonProperty(value="vipHostname")
        private String vipHostname;
        @JsonProperty(value="vip")
        private String vip;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="dbServerId")
        private String dbServerId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder ip(String ip) {
            this.ip = ip;
            this.__explicitlySet__.add("ip");
            return this;
        }

        public Builder vipHostname(String vipHostname) {
            this.vipHostname = vipHostname;
            this.__explicitlySet__.add("vipHostname");
            return this;
        }

        public Builder vip(String vip) {
            this.vip = vip;
            this.__explicitlySet__.add("vip");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            this.__explicitlySet__.add("dbServerId");
            return this;
        }

        public NodeDetails build() {
            NodeDetails model = new NodeDetails(this.hostname, this.ip, this.vipHostname, this.vip, this.lifecycleState, this.dbServerId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NodeDetails model) {
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("ip")) {
                this.ip(model.getIp());
            }
            if (model.wasPropertyExplicitlySet("vipHostname")) {
                this.vipHostname(model.getVipHostname());
            }
            if (model.wasPropertyExplicitlySet("vip")) {
                this.vip(model.getVip());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("dbServerId")) {
                this.dbServerId(model.getDbServerId());
            }
            return this;
        }
    }
}

