/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDbSystemPatchHistoryEntryRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String patchHistoryEntryId;

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getPatchHistoryEntryId() {
        return this.patchHistoryEntryId;
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).patchHistoryEntryId(this.patchHistoryEntryId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",patchHistoryEntryId=").append(String.valueOf(this.patchHistoryEntryId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDbSystemPatchHistoryEntryRequest)) {
            return false;
        }
        GetDbSystemPatchHistoryEntryRequest other = (GetDbSystemPatchHistoryEntryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.patchHistoryEntryId, other.patchHistoryEntryId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.patchHistoryEntryId == null ? 43 : this.patchHistoryEntryId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemPatchHistoryEntryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbSystemId = null;
        private String patchHistoryEntryId = null;

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder patchHistoryEntryId(String patchHistoryEntryId) {
            this.patchHistoryEntryId = patchHistoryEntryId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemPatchHistoryEntryRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.patchHistoryEntryId(o.getPatchHistoryEntryId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemPatchHistoryEntryRequest build() {
            GetDbSystemPatchHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDbSystemPatchHistoryEntryRequest buildWithoutInvocationCallback() {
            GetDbSystemPatchHistoryEntryRequest request = new GetDbSystemPatchHistoryEntryRequest();
            request.dbSystemId = this.dbSystemId;
            request.patchHistoryEntryId = this.patchHistoryEntryId;
            return request;
        }
    }
}

