/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.commands;

import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public class Authentication {
    private final String username;
    private final char[] password;
    private CallbackHandler callBackHandler;

    public Authentication() {
        this.username = "";
        this.password = new char[0];
        this.callBackHandler = this.createCallBackHandler();
    }

    public Authentication(String username, char[] password) {
        this.username = username;
        this.password = Arrays.copyOf(password, password.length);
        this.callBackHandler = this.createCallBackHandler();
    }

    private CallbackHandler createCallBackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)current;
                        nameCallback.setName(Authentication.this.username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pwdCallback = (PasswordCallback)current;
                        pwdCallback.setPassword(Authentication.this.password);
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback realmCallback = (RealmCallback)current;
                        realmCallback.setText(realmCallback.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
    }

    public CallbackHandler getCallbackHandler() {
        return this.callBackHandler;
    }
}

