/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.DashboardTransferable;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.team.commons.treelist.TreeList;
import org.netbeans.modules.team.commons.treelist.TreeListModel;

public class DashboardTransferHandler
extends TransferHandler {
    private final DataFlavor taskFlavor = DashboardTransferable.taskFlavor;

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        if (!info.isDataFlavorSupported(this.taskFlavor)) {
            return false;
        }
        Category category = this.getTargetCategory(info);
        return category != null;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JList) {
            JList list = (JList)c;
            Object[] values = list.getSelectedValues();
            if (values == null || values.length == 0) {
                return null;
            }
            ArrayList<TaskNode> nodes = new ArrayList<TaskNode>(values.length);
            for (int i = 0; i < values.length; ++i) {
                Object val = values[i];
                if (!(val instanceof TaskNode)) {
                    return null;
                }
                nodes.add((TaskNode)val);
            }
            return new DashboardTransferable(nodes.toArray(new TaskNode[0]));
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        TaskNode[] data;
        if (!info.isDrop()) {
            return false;
        }
        Category category = this.getTargetCategory(info);
        if (category == null) {
            return false;
        }
        Transferable t = info.getTransferable();
        try {
            data = (TaskNode[])t.getTransferData(this.taskFlavor);
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        DashboardViewer.getInstance().addTaskToCategory(category, data);
        return true;
    }

    private Category getTargetCategory(TransferHandler.TransferSupport info) {
        TreeList list = (TreeList)info.getComponent();
        TreeListModel listModel = (TreeListModel)list.getModel();
        JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
        int index = dl.getIndex();
        Object elementAt = listModel.getElementAt(index);
        if (dl.isInsert()) {
            if (elementAt instanceof TaskNode) {
                Category category = ((TaskNode)elementAt).getCategory();
                return category != null && category.persist() ? category : null;
            }
            Object elementAtPrevious = listModel.getElementAt(index - 1);
            if (elementAtPrevious instanceof TaskNode) {
                Category category = ((TaskNode)elementAtPrevious).getCategory();
                return category != null && category.persist() ? category : null;
            }
            return null;
        }
        if (!(elementAt instanceof CategoryNode)) {
            return null;
        }
        Category category = ((CategoryNode)elementAt).getCategory();
        return category != null && category.persist() ? category : null;
    }
}

