/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.tasks.Bundle;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.openide.util.ChangeSupport;

public class SchedulingPickerImpl
extends JPanel {
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private IssueScheduleInfo currentValue;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(2);
    private boolean setting;
    private JButton popupButton;
    private JFormattedTextField scheduleTextComponent;

    public SchedulingPickerImpl() {
        this.initComponents();
    }

    public JComponent getComponent() {
        return this;
    }

    public IssueScheduleInfo getScheduleDate() {
        return this.currentValue;
    }

    public void setScheduleDate(IssueScheduleInfo info) {
        this.currentValue = info;
        this.setting = true;
        this.scheduleTextComponent.setValue(info);
        this.setting = false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.scheduleTextComponent.setEnabled(enabled);
        this.popupButton.setEnabled(enabled);
    }

    private void initComponents() {
        this.scheduleTextComponent = new JFormattedTextField();
        this.popupButton = new JButton();
        this.scheduleTextComponent.setFormatterFactory(new DefaultFormatterFactory(new SchedulingDisplayFormatter(), null, new SchedulingEditFormatter(), null));
        this.scheduleTextComponent.setMargin(new Insets(2, 2, 2, 2));
        this.scheduleTextComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SchedulingPickerImpl.this.scheduleTextComponentPropertyChange(evt);
            }
        });
        this.popupButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/bugtracking/tasks/resources/arrow-down.png")));
        this.popupButton.setMargin(new Insets(2, 2, 2, 2));
        this.popupButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SchedulingPickerImpl.this.popupButtonMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scheduleTextComponent, -2, 200, -2).addGap(0, 0, 0).addComponent(this.popupButton).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.scheduleTextComponent, -2, -1, -2).addComponent(this.popupButton, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
    }

    private void popupButtonMousePressed(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.showSchedulingPopup();
        }
    }

    private void scheduleTextComponentPropertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName()) && (evt.getOldValue() != null || evt.getNewValue() != null)) {
            this.updateCurrentValue((IssueScheduleInfo)this.scheduleTextComponent.getValue());
        }
    }

    private void updateCurrentValue(IssueScheduleInfo info) {
        if (!this.setting && (this.currentValue == null && info != null || this.currentValue != null && !this.currentValue.equals(info))) {
            this.currentValue = info;
            this.scheduleTextComponent.setValue(info);
            this.support.fireChange();
        }
    }

    private void showSchedulingPopup() {
        final DashboardUtils.SchedulingMenu menu = new DashboardUtils.SchedulingMenu(this.currentValue);
        menu.addChangeListener(new ChangeListener(){
            final /* synthetic */ SchedulingPickerImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.this$0.updateCurrentValue(menu.getScheduleInfo());
                menu.removeChangeListener(this);
            }
        });
        JPopupMenu popup = new JPopupMenu();
        for (JMenuItem item : menu.getMenuItems()) {
            if (item == null) {
                popup.addSeparator();
                continue;
            }
            popup.add(item);
        }
        Point p = this.scheduleTextComponent.getLocation();
        popup.show(this.scheduleTextComponent.getParent(), p.x, p.y + this.scheduleTextComponent.getSize().height + 1);
    }

    private static String toDisplayable(IssueScheduleInfo info) {
        Date date = info.getDate();
        int interval = info.getInterval();
        Calendar cal = Calendar.getInstance();
        SchedulingPickerImpl.stripTime(cal);
        Calendar scheduleDay = Calendar.getInstance();
        scheduleDay.setTime(date);
        SchedulingPickerImpl.stripTime(scheduleDay);
        if (interval <= 1) {
            String dayName = scheduleDay.getDisplayName(7, 2, Locale.getDefault());
            for (int i = 0; i < 7; ++i) {
                if (cal.getTime().equals(scheduleDay.getTime())) {
                    if (i == 0) {
                        dayName = Bundle.CTL_Today(dayName);
                    }
                    return dayName;
                }
                cal.add(5, 1);
            }
            return DATE_FORMAT.format(date);
        }
        scheduleDay.setTime(date);
        SchedulingPickerImpl.stripTime(scheduleDay);
        Calendar until = Calendar.getInstance();
        until.setTime(date);
        SchedulingPickerImpl.stripTime(until);
        until.add(5, interval);
        if (SchedulingPickerImpl.isThisWeek(scheduleDay, until)) {
            return Bundle.CTL_ThisWeek();
        }
        if (SchedulingPickerImpl.isNextWeek(scheduleDay, until)) {
            return Bundle.CTL_NextWeek();
        }
        return Bundle.CTL_SpecificDates(DATE_FORMAT.format(scheduleDay.getTime()), DATE_FORMAT.format(until.getTime()));
    }

    private static void stripTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private static boolean isThisWeek(Calendar scheduleDay, Calendar until) {
        Calendar weekStart = Calendar.getInstance();
        SchedulingPickerImpl.stripTime(weekStart);
        weekStart.set(7, weekStart.getFirstDayOfWeek());
        Calendar weekEnd = Calendar.getInstance();
        weekEnd.setTime(weekStart.getTime());
        weekEnd.add(5, 7);
        return scheduleDay.equals(weekStart) && until.equals(weekEnd);
    }

    private static boolean isNextWeek(Calendar scheduleDay, Calendar until) {
        Calendar weekStart = Calendar.getInstance();
        SchedulingPickerImpl.stripTime(weekStart);
        weekStart.set(7, weekStart.getFirstDayOfWeek());
        weekStart.add(5, 7);
        Calendar weekEnd = Calendar.getInstance();
        weekEnd.setTime(weekStart.getTime());
        weekEnd.add(5, 7);
        return scheduleDay.equals(weekStart) && until.equals(weekEnd);
    }

    private static class SchedulingDisplayFormatter
    extends JFormattedTextField.AbstractFormatter {
        private SchedulingDisplayFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return null;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value instanceof IssueScheduleInfo) {
                return SchedulingPickerImpl.toDisplayable((IssueScheduleInfo)value);
            }
            return Bundle.CTL_NotScheduled();
        }
    }

    private static class SchedulingEditFormatter
    extends DateFormatter {
        private SchedulingEditFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if (text == null || text.isEmpty()) {
                return null;
            }
            Date date = (Date)super.stringToValue(text);
            return new IssueScheduleInfo(date);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value instanceof IssueScheduleInfo) {
                return super.valueToString(((IssueScheduleInfo)value).getDate());
            }
            return null;
        }
    }
}

