/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchPopup;

class SearchResultRenderer
extends JLabel
implements ListCellRenderer {
    private QuickSearchPopup popup;
    private QuickSearchComboBar combo;
    private JPanel rendererComponent;
    private JPanel dividerLine;
    private JLabel resultLabel;
    private JPanel itemPanel;

    public SearchResultRenderer(QuickSearchComboBar combo, QuickSearchPopup popup) {
        this.popup = popup;
        this.combo = combo;
        this.configRenderer();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof PopupItem)) {
            BugtrackingManager.LOG.log(Level.WARNING, "wrong search list item {0}", value);
            return new JLabel();
        }
        PopupItem item = (PopupItem)value;
        String txt = item instanceof PopupItem.IssueItem ? ((PopupItem.IssueItem)item).highlite(this.combo.getText(), item.getDisplayText()) : item.getDisplayText();
        this.resultLabel.setText(txt);
        this.itemPanel.setPreferredSize(new Dimension(this.popup.getResultWidth(), this.itemPanel.getPreferredSize().height));
        if (isSelected) {
            this.resultLabel.setBackground(list.getSelectionBackground());
            this.resultLabel.setForeground(list.getSelectionForeground());
        } else {
            this.resultLabel.setBackground(QuickSearchComboBar.getResultBackground());
            this.resultLabel.setForeground(list.getForeground());
        }
        if (index == list.getModel().getSize() - 1) {
            this.rendererComponent.add((Component)this.dividerLine, "North");
        } else {
            this.rendererComponent.remove(this.dividerLine);
        }
        return this.rendererComponent;
    }

    private void configRenderer() {
        this.resultLabel = new JLabel();
        this.resultLabel.setOpaque(true);
        this.resultLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.itemPanel = new JPanel();
        this.itemPanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.itemPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 3));
        this.itemPanel.setLayout(new BorderLayout());
        this.itemPanel.add((Component)this.resultLabel, "Center");
        this.rendererComponent = new JPanel();
        this.rendererComponent.setLayout(new BorderLayout());
        this.rendererComponent.add((Component)this.itemPanel, "Center");
        this.dividerLine = new JPanel();
        this.dividerLine.setBackground(QuickSearchComboBar.getPopupBorderColor());
        this.dividerLine.setPreferredSize(new Dimension(this.dividerLine.getPreferredSize().width, 1));
    }
}

