/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteNodeRequest
extends BmcRequest<Void> {
    private String nodePoolId;
    private String nodeId;
    private Boolean isDecrementSize;
    private String ifMatch;
    private String opcRequestId;
    private String overrideEvictionGraceDuration;
    private Boolean isForceDeletionAfterOverrideGraceDuration;

    public String getNodePoolId() {
        return this.nodePoolId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Boolean getIsDecrementSize() {
        return this.isDecrementSize;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOverrideEvictionGraceDuration() {
        return this.overrideEvictionGraceDuration;
    }

    public Boolean getIsForceDeletionAfterOverrideGraceDuration() {
        return this.isForceDeletionAfterOverrideGraceDuration;
    }

    public Builder toBuilder() {
        return new Builder().nodePoolId(this.nodePoolId).nodeId(this.nodeId).isDecrementSize(this.isDecrementSize).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).overrideEvictionGraceDuration(this.overrideEvictionGraceDuration).isForceDeletionAfterOverrideGraceDuration(this.isForceDeletionAfterOverrideGraceDuration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",nodePoolId=").append(String.valueOf(this.nodePoolId));
        sb.append(",nodeId=").append(String.valueOf(this.nodeId));
        sb.append(",isDecrementSize=").append(String.valueOf(this.isDecrementSize));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",overrideEvictionGraceDuration=").append(String.valueOf(this.overrideEvictionGraceDuration));
        sb.append(",isForceDeletionAfterOverrideGraceDuration=").append(String.valueOf(this.isForceDeletionAfterOverrideGraceDuration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteNodeRequest)) {
            return false;
        }
        DeleteNodeRequest other = (DeleteNodeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.nodePoolId, other.nodePoolId) && Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.isDecrementSize, other.isDecrementSize) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.overrideEvictionGraceDuration, other.overrideEvictionGraceDuration) && Objects.equals(this.isForceDeletionAfterOverrideGraceDuration, other.isForceDeletionAfterOverrideGraceDuration);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.nodePoolId == null ? 43 : this.nodePoolId.hashCode());
        result = result * 59 + (this.nodeId == null ? 43 : this.nodeId.hashCode());
        result = result * 59 + (this.isDecrementSize == null ? 43 : this.isDecrementSize.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.overrideEvictionGraceDuration == null ? 43 : this.overrideEvictionGraceDuration.hashCode());
        result = result * 59 + (this.isForceDeletionAfterOverrideGraceDuration == null ? 43 : this.isForceDeletionAfterOverrideGraceDuration.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteNodeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String nodePoolId = null;
        private String nodeId = null;
        private Boolean isDecrementSize = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String overrideEvictionGraceDuration = null;
        private Boolean isForceDeletionAfterOverrideGraceDuration = null;

        public Builder nodePoolId(String nodePoolId) {
            this.nodePoolId = nodePoolId;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder isDecrementSize(Boolean isDecrementSize) {
            this.isDecrementSize = isDecrementSize;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder overrideEvictionGraceDuration(String overrideEvictionGraceDuration) {
            this.overrideEvictionGraceDuration = overrideEvictionGraceDuration;
            return this;
        }

        public Builder isForceDeletionAfterOverrideGraceDuration(Boolean isForceDeletionAfterOverrideGraceDuration) {
            this.isForceDeletionAfterOverrideGraceDuration = isForceDeletionAfterOverrideGraceDuration;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteNodeRequest o) {
            this.nodePoolId(o.getNodePoolId());
            this.nodeId(o.getNodeId());
            this.isDecrementSize(o.getIsDecrementSize());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.overrideEvictionGraceDuration(o.getOverrideEvictionGraceDuration());
            this.isForceDeletionAfterOverrideGraceDuration(o.getIsForceDeletionAfterOverrideGraceDuration());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteNodeRequest build() {
            DeleteNodeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteNodeRequest buildWithoutInvocationCallback() {
            DeleteNodeRequest request = new DeleteNodeRequest();
            request.nodePoolId = this.nodePoolId;
            request.nodeId = this.nodeId;
            request.isDecrementSize = this.isDecrementSize;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.overrideEvictionGraceDuration = this.overrideEvictionGraceDuration;
            request.isForceDeletionAfterOverrideGraceDuration = this.isForceDeletionAfterOverrideGraceDuration;
            return request;
        }
    }
}

