/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.actions;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.web.jsf.editor.PositionRange;
import org.netbeans.modules.web.jsf.editor.actions.ImportData;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.util.Exceptions;

class FixNamespacesPerformer {
    private final HtmlParserResult parserResult;
    private final ImportData importData;
    private final List<ImportData.VariantItem> selections;
    private final boolean removeUnused;
    private BaseDocument baseDocument;

    public FixNamespacesPerformer(HtmlParserResult parserResult, ImportData importData, List<ImportData.VariantItem> selections, boolean removeUnused) {
        this.parserResult = parserResult;
        this.importData = importData;
        this.selections = selections;
        this.removeUnused = removeUnused;
    }

    void perform() {
        Document document = this.parserResult.getSnapshot().getSource().getDocument(false);
        if (document instanceof BaseDocument) {
            this.baseDocument = (BaseDocument)document;
            this.baseDocument.runAtomic(new Runnable(){

                @Override
                public void run() {
                    FixNamespacesPerformer.this.includeMissingNamespaces();
                    if (FixNamespacesPerformer.this.removeUnused) {
                        FixNamespacesPerformer.this.removeUnusedNamespaces();
                    }
                }
            });
        }
    }

    private void removeUnusedNamespaces() {
        try {
            ArrayList<PositionRange> ranges = new ArrayList<PositionRange>(this.importData.getItemsToRemove().size());
            for (Attribute attribute : this.importData.getItemsToRemove()) {
                int firstNonWhite;
                int from = attribute.from();
                int to = attribute.to();
                int lineBeginning = Utilities.getRowStart((BaseDocument)this.baseDocument, (int)attribute.from());
                if (lineBeginning > (firstNonWhite = Utilities.getFirstNonWhiteBwd((BaseDocument)this.baseDocument, (int)attribute.from()))) {
                    from = lineBeginning - 1;
                }
                ranges.add(new PositionRange(this.baseDocument, from, to));
            }
            for (PositionRange positionRange : ranges) {
                this.baseDocument.remove(positionRange.getFrom(), positionRange.getTo() - positionRange.getFrom());
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void includeMissingNamespaces() {
        for (ImportData.VariantItem variant : this.selections) {
            LibraryUtils.importLibrary((Document)this.baseDocument, (Library)variant.getLibrary(), (String)variant.getPrefix());
        }
    }
}

