/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.objectstorage.model.ObjectNameFilter;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ObjectLifecycleRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="target")
    private final String target;
    @JsonProperty(value="action")
    private final String action;
    @JsonProperty(value="timeAmount")
    private final Long timeAmount;
    @JsonProperty(value="timeUnit")
    private final TimeUnit timeUnit;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="objectNameFilter")
    private final ObjectNameFilter objectNameFilter;

    @Deprecated
    @ConstructorProperties(value={"name", "target", "action", "timeAmount", "timeUnit", "isEnabled", "objectNameFilter"})
    public ObjectLifecycleRule(String name, String target, String action, Long timeAmount, TimeUnit timeUnit, Boolean isEnabled, ObjectNameFilter objectNameFilter) {
        this.name = name;
        this.target = target;
        this.action = action;
        this.timeAmount = timeAmount;
        this.timeUnit = timeUnit;
        this.isEnabled = isEnabled;
        this.objectNameFilter = objectNameFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    public String getAction() {
        return this.action;
    }

    public Long getTimeAmount() {
        return this.timeAmount;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public ObjectNameFilter getObjectNameFilter() {
        return this.objectNameFilter;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectLifecycleRule(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", target=").append(String.valueOf(this.target));
        sb.append(", action=").append(String.valueOf(this.action));
        sb.append(", timeAmount=").append(String.valueOf(this.timeAmount));
        sb.append(", timeUnit=").append(String.valueOf((Object)this.timeUnit));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", objectNameFilter=").append(String.valueOf((Object)this.objectNameFilter));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectLifecycleRule)) {
            return false;
        }
        ObjectLifecycleRule other = (ObjectLifecycleRule)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.target, other.target) && Objects.equals(this.action, other.action) && Objects.equals(this.timeAmount, other.timeAmount) && Objects.equals((Object)this.timeUnit, (Object)other.timeUnit) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals((Object)this.objectNameFilter, (Object)other.objectNameFilter) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.timeAmount == null ? 43 : this.timeAmount.hashCode());
        result = result * 59 + (this.timeUnit == null ? 43 : this.timeUnit.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.objectNameFilter == null ? 43 : this.objectNameFilter.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TimeUnit implements BmcEnum
    {
        Days("DAYS"),
        Years("YEARS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TimeUnit> map;

        private TimeUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TimeUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TimeUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TimeUnit.class);
            map = new HashMap<String, TimeUnit>();
            for (TimeUnit v : TimeUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="target")
        private String target;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="timeAmount")
        private Long timeAmount;
        @JsonProperty(value="timeUnit")
        private TimeUnit timeUnit;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="objectNameFilter")
        private ObjectNameFilter objectNameFilter;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder timeAmount(Long timeAmount) {
            this.timeAmount = timeAmount;
            this.__explicitlySet__.add("timeAmount");
            return this;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            this.__explicitlySet__.add("timeUnit");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder objectNameFilter(ObjectNameFilter objectNameFilter) {
            this.objectNameFilter = objectNameFilter;
            this.__explicitlySet__.add("objectNameFilter");
            return this;
        }

        public ObjectLifecycleRule build() {
            ObjectLifecycleRule model = new ObjectLifecycleRule(this.name, this.target, this.action, this.timeAmount, this.timeUnit, this.isEnabled, this.objectNameFilter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectLifecycleRule model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("timeAmount")) {
                this.timeAmount(model.getTimeAmount());
            }
            if (model.wasPropertyExplicitlySet("timeUnit")) {
                this.timeUnit(model.getTimeUnit());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("objectNameFilter")) {
                this.objectNameFilter(model.getObjectNameFilter());
            }
            return this;
        }
    }
}

