/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript2.editor.JsVersion;

public class JsPreferences {
    private static final JsVersion DEFAULT_JS_VERSION = JsVersion.EMCANEXT;
    private static final String JS_PREF_TAG = "jsversion";

    public static List<JsVersion> getECMAScriptAvailableVersions() {
        return new ArrayList<JsVersion>(EnumSet.allOf(JsVersion.class));
    }

    public static JsVersion getECMAScriptVersion(Project project) {
        if (project != null) {
            String strValue = JsPreferences.getPreferences(project).get(JS_PREF_TAG, null);
            JsVersion version = JsVersion.fromString(strValue);
            if (version == null) {
                version = DEFAULT_JS_VERSION;
            }
            return version;
        }
        return DEFAULT_JS_VERSION;
    }

    public static void putECMAScriptVersion(Project project, JsVersion version) {
        if (project != null) {
            if (!version.equals((Object)DEFAULT_JS_VERSION)) {
                JsPreferences.getPreferences(project).put(JS_PREF_TAG, version.toString());
            } else {
                JsPreferences.getPreferences(project).remove(JS_PREF_TAG);
            }
        }
    }

    private static Preferences getPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, JsPreferences.class, (boolean)true);
    }

    public static boolean isPreECMAVersion(Project project, JsVersion target) {
        return JsPreferences.getECMAScriptVersion(project).ordinal() < target.ordinal();
    }
}

