/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.QueryTimeout;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.Bits;

final class TimeLimitingBulkScorer
extends BulkScorer {
    static final int INTERVAL = 100;
    private final BulkScorer in;
    private final QueryTimeout queryTimeout;

    public TimeLimitingBulkScorer(BulkScorer bulkScorer, QueryTimeout queryTimeout) {
        this.in = bulkScorer;
        this.queryTimeout = Objects.requireNonNull(queryTimeout);
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
        int interval = 100;
        while (min < max) {
            int newMax = (int)Math.min((long)min + (long)interval, (long)max);
            int newInterval = interval + (interval >> 1);
            if (interval < newInterval) {
                interval = newInterval;
            }
            if (this.queryTimeout.shouldExit()) {
                throw new TimeExceededException();
            }
            min = this.in.score(collector, acceptDocs, min, newMax);
        }
        return min;
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    static class TimeExceededException
    extends RuntimeException {
        private TimeExceededException() {
            super("TimeLimit Exceeded");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

