/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EnvEntry;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EnvEntryPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EnvEntryTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EnvEntriesTablePanel
extends DefaultTablePanel {
    private EnvEntryTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;

    public EnvEntriesTablePanel(final DDDataObject dObj, final EnvEntryTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.dObj = dObj;
        this.removeButton.addActionListener(new ActionListener(){
            final /* synthetic */ EnvEntriesTablePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                dObj.modelUpdatedFromUI();
                dObj.setChangedFromUI(true);
                int row = this.this$0.getTable().getSelectedRow();
                model.removeRow(row);
                dObj.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, EnvEntry[] params) {
        this.model.setData((CommonDDBean)webApp, (CommonDDBean[])params);
        this.webApp = webApp;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int row = this.add ? -1 : EnvEntriesTablePanel.this.getTable().getSelectedRow();
            final EnvEntryPanel dialogPanel = new EnvEntryPanel();
            if (!this.add) {
                EnvEntry envEntry = EnvEntriesTablePanel.this.model.getEnvEntry(row);
                dialogPanel.setEnvEntryName(envEntry.getEnvEntryName());
                dialogPanel.setEnvEntryType(envEntry.getEnvEntryType());
                dialogPanel.setEnvEntryValue(envEntry.getEnvEntryValue());
                dialogPanel.setDescription(envEntry.getDefaultDescription());
            }
            EditDialog dialog = new EditDialog(this, dialogPanel, NbBundle.getMessage(EnvEntriesTablePanel.class, (String)"TTL_EnvEntry"), this.add){
                final /* synthetic */ TableActionListener this$1;
                {
                    this.this$1 = this$1;
                    super(panel, title, adding);
                }

                protected String validate() {
                    String name = dialogPanel.getEnvEntryName().trim();
                    if (name.length() == 0) {
                        return NbBundle.getMessage(EnvEntriesTablePanel.class, (String)"TXT_EmptyEnvEntryName");
                    }
                    EnvEntry[] params = this.this$1.EnvEntriesTablePanel.this.webApp.getEnvEntry();
                    boolean exists = false;
                    for (int i = 0; i < params.length; ++i) {
                        if (row == i || !name.equals(params[i].getEnvEntryName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) {
                        return NbBundle.getMessage(EnvEntriesTablePanel.class, (String)"TXT_EnvEntryNameExists", (Object)name);
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                EnvEntriesTablePanel.this.dObj.modelUpdatedFromUI();
                EnvEntriesTablePanel.this.dObj.setChangedFromUI(true);
                String name = dialogPanel.getEnvEntryName().trim();
                String type = dialogPanel.getEnvEntryType();
                String value = dialogPanel.getEnvEntryValue().trim();
                String description = dialogPanel.getDescription();
                if (this.add) {
                    EnvEntriesTablePanel.this.model.addRow(new String[]{name, type, value, description});
                } else {
                    EnvEntriesTablePanel.this.model.editRow(row, new String[]{name, type, value, description});
                }
                EnvEntriesTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

