/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.locals;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.debug.NamesTranslator;
import org.netbeans.modules.javascript2.debug.ui.models.ViewModelSupport;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.javascript.debugger.eval.EvaluatorService;
import org.netbeans.modules.web.javascript.debugger.eval.VarNamesTranslatorFactory;
import org.netbeans.modules.web.javascript.debugger.locals.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.PropertyDescriptor;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Scope;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class VariablesModel
extends ViewModelSupport
implements TreeModel,
ExtendedNodeModel,
TableModel,
Debugger.Listener,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(VariablesModel.class.getName());
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/local_variable_16.png";
    public static final String GLOBAL = "org/netbeans/modules/javascript2/debug/ui/resources/global_variable_16.png";
    public static final String PROTO = "org/netbeans/modules/javascript2/debug/ui/resources/proto_variable_16.png";
    protected final Debugger debugger;
    protected final EvaluatorService evaluator;
    protected final ProjectContext pc;
    private final Map<String, ScopedRemoteObject> scopeVars = new HashMap<String, ScopedRemoteObject>();
    protected final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private AtomicReference<CallFrame> currentStack = new AtomicReference();
    private Map<RemoteObject, List<ScopedRemoteObject>> variablesCache = new HashMap<RemoteObject, List<ScopedRemoteObject>>();
    private RequestProcessor RP = new RequestProcessor(VariablesModel.class.getName());

    public VariablesModel(ContextProvider contextProvider) {
        this.debugger = (Debugger)contextProvider.lookupFirst(null, Debugger.class);
        this.evaluator = (EvaluatorService)contextProvider.lookupFirst(null, EvaluatorService.class);
        this.pc = (ProjectContext)contextProvider.lookupFirst(null, ProjectContext.class);
        this.debugger.addListener((Debugger.Listener)this);
        this.debugger.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.debugger.isSuspended()) {
            this.currentStack.set(this.debugger.getCurrentCallFrame());
        } else {
            this.currentStack.set(null);
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        CallFrame frame = this.currentStack.get();
        if (frame == null) {
            return new Object[0];
        }
        if (parent == "Root") {
            return this.getVariables(frame).subList(from, to).toArray();
        }
        if (parent instanceof ScopedRemoteObject) {
            return this.getProperties((ScopedRemoteObject)parent).toArray();
        }
        throw new UnknownTypeException(parent);
    }

    protected CallFrame getCurrentStack() {
        return this.currentStack.get();
    }

    private List<ScopedRemoteObject> getVariables(CallFrame frame) {
        ArrayList<ScopedRemoteObject> vars = new ArrayList<ScopedRemoteObject>();
        for (Scope scope : frame.getScopes()) {
            RemoteObject obj = scope.getScopeObject();
            if (scope.isLocalScope()) {
                vars.addAll(this.getProperties(obj, ViewScope.LOCAL, null));
                continue;
            }
            vars.add(this.getScopeVariable(obj, scope));
        }
        this.translate(vars, frame);
        return this.sortVariables(vars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScopedRemoteObject getScopeVariable(RemoteObject obj, Scope scope) {
        String scopeType = scope.getType();
        Map<String, ScopedRemoteObject> map = this.scopeVars;
        synchronized (map) {
            ScopedRemoteObject sro = this.scopeVars.get(scopeType);
            if (sro == null) {
                sro = new ScopedRemoteObject(obj, scope);
                this.scopeVars.put(scopeType, sro);
            }
            return sro;
        }
    }

    private List<ScopedRemoteObject> sortVariables(List<ScopedRemoteObject> vars) {
        vars.sort(new Comparator<ScopedRemoteObject>(){

            @Override
            public int compare(ScopedRemoteObject o1, ScopedRemoteObject o2) {
                int i = o1.getScope().compareTo(o2.getScope());
                if (i != 0) {
                    return i;
                }
                if (o1.isArrayElement() && o2.isArrayElement()) {
                    return Long.signum(o1.getArrayIndex() - o2.getArrayIndex());
                }
                return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
            }
        });
        return vars;
    }

    private Collection<? extends ScopedRemoteObject> getProperties(ScopedRemoteObject var) {
        String parentNameID = var.parentNameID;
        parentNameID = parentNameID == null ? var.getObjectName() : parentNameID + "/" + var.getObjectName();
        return this.getProperties(var.getRemoteObject(), ViewScope.DEFAULT, parentNameID);
    }

    private Collection<? extends ScopedRemoteObject> getProperties(RemoteObject prop, ViewScope scope, String parentNameID) {
        List<ScopedRemoteObject> res = this.variablesCache.get(prop);
        if (res != null) {
            return res;
        }
        res = new ArrayList<ScopedRemoteObject>();
        this.variablesCache.put(prop, res);
        if (prop.getType() == RemoteObject.Type.OBJECT) {
            RemoteObject.SubType subType = prop.getSubType();
            boolean isArray = RemoteObject.SubType.ARRAY.equals((Object)subType);
            for (PropertyDescriptor desc : prop.getProperties()) {
                long arrayIndex = -1L;
                if (isArray) {
                    try {
                        arrayIndex = Long.parseLong(desc.getName());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ScopedRemoteObject sro = new ScopedRemoteObject(desc.getValue(), desc.getName(), scope, parentNameID, arrayIndex);
                res.add(sro);
            }
        }
        return this.sortVariables(res);
    }

    private void translate(List<ScopedRemoteObject> vars, CallFrame frame) {
        VarNamesTranslatorFactory vtf = VarNamesTranslatorFactory.get(frame, this.debugger, this.pc.getProject());
        NamesTranslator namesTranslator = vtf.getNamesTranslator();
        if (namesTranslator == null) {
            return;
        }
        for (ScopedRemoteObject sro : vars) {
            String name = sro.getObjectName();
            String tname = namesTranslator.translate(name);
            sro.setObjectDisplayName(tname);
        }
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof ScopedRemoteObject) {
            RemoteObject var = ((ScopedRemoteObject)node).getRemoteObject();
            if (var != null && var.getType() == RemoteObject.Type.OBJECT) {
                if (RemoteObject.SubType.ERROR.equals((Object)var.getSubType())) {
                    return true;
                }
                if (var.hasFetchedProperties()) {
                    return var.getProperties().isEmpty();
                }
                this.updateNodeOnBackground(node, var);
                return false;
            }
            return true;
        }
        throw new UnknownTypeException(node);
    }

    protected void updateNodeOnBackground(final Object node, final RemoteObject var) {
        this.RP.post(new Runnable(){
            final /* synthetic */ VariablesModel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.getCurrentStack() == null) {
                    return;
                }
                var.getProperties();
                this.this$0.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, node, 16));
            }
        });
    }

    public int getChildrenCount(Object parent) throws UnknownTypeException {
        CallFrame frame = this.currentStack.get();
        if (frame == null) {
            return 0;
        }
        if (parent == "Root") {
            return this.getVariables(frame).size();
        }
        if (parent instanceof ScopedRemoteObject) {
            return this.getProperties((ScopedRemoteObject)parent).size();
        }
        throw new UnknownTypeException(parent);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Bundle.VariablesModel_Name();
        }
        if (node instanceof ScopedRemoteObject) {
            return ((ScopedRemoteObject)node).getObjectDisplayName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        assert (node != "Root");
        if (node instanceof ScopedRemoteObject) {
            ScopedRemoteObject sv = (ScopedRemoteObject)node;
            switch (sv.getScope().ordinal()) {
                case 5: {
                    return PROTO;
                }
                case 0: 
                case 4: {
                    return LOCAL;
                }
            }
            return GLOBAL;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Bundle.VariablesModel_Desc();
        }
        if (node instanceof ScopedRemoteObject) {
            return ((ScopedRemoteObject)node).getObjectName();
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node == "Root") {
            return "";
        }
        if (node instanceof ScopedRemoteObject) {
            RemoteObject var = ((ScopedRemoteObject)node).getRemoteObject();
            if ("LocalsValue".equals(columnID)) {
                RemoteObject.Type type;
                if (var == null) {
                    return null;
                }
                String value = var.getValueAsString();
                if (value.isEmpty() && ((type = var.getType()) == RemoteObject.Type.OBJECT || type == RemoteObject.Type.FUNCTION)) {
                    value = var.getDescription();
                }
                return VariablesModel.toHTML((String)value);
            }
            if ("LocalsType".equals(columnID)) {
                if (var == null) {
                    return "";
                }
                RemoteObject.Type type = var.getType();
                if (type == RemoteObject.Type.OBJECT) {
                    String clazz = var.getClassName();
                    if (clazz == null) {
                        return VariablesModel.toHTML((String)type.getName());
                    }
                    return VariablesModel.toHTML((String)clazz);
                }
                return VariablesModel.toHTML((String)type.getName());
            }
            if ("LocalsToString".equals(columnID)) {
                if (var == null) {
                    return null;
                }
                return VariablesModel.toHTML((String)var.getValueAsString());
            }
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if ("LocalsValue".equals(columnID) && node instanceof ScopedRemoteObject || "WatchValue".equals(columnID) && node instanceof ScopedRemoteObject) {
            return true;
        }
        return true;
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if ("LocalsValue".equals(columnID) && node instanceof ScopedRemoteObject) {
            ScopedRemoteObject sro = (ScopedRemoteObject)node;
            this.evaluator.evaluateExpression(this.getCurrentStack(), sro.getObjectName() + "=" + value + ";", false);
            this.refresh();
        }
        throw new UnknownTypeException(node);
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.currentStack.set(this.debugger.getCurrentCallFrame());
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumed() {
        this.currentStack.set(null);
        this.variablesCache = new HashMap<RemoteObject, List<ScopedRemoteObject>>();
        Map<String, ScopedRemoteObject> map = this.scopeVars;
        synchronized (map) {
            this.scopeVars.clear();
        }
        this.refresh();
    }

    public void reset() {
    }

    public void enabled(boolean enabled) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("currentFrame".equals(propertyName)) {
            this.currentStack.set(this.debugger.getCurrentCallFrame());
            this.refresh();
        }
    }

    public static class ScopedRemoteObject {
        private RemoteObject var;
        private ViewScope scope;
        private String objectName;
        private String objectDisplayName;
        private String parentNameID;
        private long arrayElementIndex;

        ScopedRemoteObject(RemoteObject var, Scope sc) {
            this.var = var;
            if (sc.isLocalScope()) {
                this.scope = ViewScope.LOCAL;
                this.objectName = Bundle.Scope_Local();
            } else if (sc.isGlobalScope()) {
                this.scope = ViewScope.GLOBAL;
                this.objectName = Bundle.Scope_Global();
            } else if (sc.isCatchScope()) {
                this.scope = ViewScope.CATCH;
                this.objectName = Bundle.Scope_Catch();
            } else if (sc.isClosureScope()) {
                this.scope = ViewScope.CLOSURE;
                this.objectName = Bundle.Scope_Closure();
            } else if (sc.isWithScope()) {
                this.scope = ViewScope.WITH;
                this.objectName = Bundle.Scope_With();
            } else {
                this.scope = ViewScope.UNKNOWN;
                String type = sc.getType();
                if (type.length() > 1) {
                    type = Character.toUpperCase(type.charAt(0)) + type.substring(1);
                }
                this.objectName = type;
            }
            this.objectDisplayName = this.objectName;
        }

        public ScopedRemoteObject(RemoteObject var, String name, ViewScope scope) {
            this(var, name, scope, null, -1L);
        }

        ScopedRemoteObject(RemoteObject var, String name, ViewScope scope, String parentNameID, long arrayElementIndex) {
            this.var = var;
            this.scope = scope;
            this.objectName = name;
            this.objectDisplayName = name;
            this.parentNameID = parentNameID;
            this.arrayElementIndex = arrayElementIndex;
        }

        public ViewScope getScope() {
            if ("__proto__".equals(this.objectName)) {
                return ViewScope.PROTO;
            }
            return this.scope;
        }

        public RemoteObject getRemoteObject() {
            return this.var;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getObjectDisplayName() {
            return this.objectDisplayName;
        }

        public void setObjectDisplayName(String objectDisplayName) {
            this.objectDisplayName = objectDisplayName;
        }

        boolean isArrayElement() {
            return this.arrayElementIndex >= 0L;
        }

        long getArrayIndex() {
            return this.arrayElementIndex;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScopedRemoteObject)) {
                return false;
            }
            ScopedRemoteObject sro = (ScopedRemoteObject)obj;
            if (LOGGER.isLoggable(Level.FINE)) {
                String parent1 = this.parentNameID != null ? ", parent = '" + this.parentNameID + "'" : "";
                String parent2 = sro.parentNameID != null ? ", parent = '" + sro.parentNameID + "'" : "";
                LOGGER.fine("Equals: " + (Object)((Object)this.scope) + ", " + this.objectName + ", " + this.var + parent1 + "\n        " + (Object)((Object)sro.scope) + ", " + sro.objectName + ", " + sro.var + parent2 + "\n  => " + (this.scope == sro.scope && Objects.equals(this.parentNameID, sro.parentNameID) && Objects.equals(this.objectName, sro.objectName) && this.areSameVars(this.var, sro.var)));
            }
            return this.scope == sro.scope && Objects.equals(this.parentNameID, sro.parentNameID) && Objects.equals(this.objectName, sro.objectName) && this.areSameVars(this.var, sro.var);
        }

        public int hashCode() {
            if (this.var == null) {
                return Objects.hash(new Object[]{this.scope, this.objectName, this.parentNameID});
            }
            return Objects.hash(new Object[]{this.scope, this.objectName, this.var.getType(), this.var.getClassName(), this.parentNameID});
        }

        private boolean areSameVars(RemoteObject var1, RemoteObject var2) {
            if (var1 == null && var2 == null) {
                return true;
            }
            if (var1 == null || var2 == null) {
                return false;
            }
            RemoteObject.Type type1 = var1.getType();
            RemoteObject.Type type2 = var2.getType();
            String className1 = var1.getClassName();
            String className2 = var2.getClassName();
            return type1 == type2 && Objects.equals(className1, className2);
        }

        public String toString() {
            String parent = this.parentNameID != null ? ", parent = '" + this.parentNameID + "'" : "";
            return "ScopedRemoteObject[" + (Object)((Object)this.scope) + ", " + this.objectName + ", " + this.var + parent + "]";
        }
    }

    public static enum ViewScope {
        LOCAL,
        CATCH,
        CLOSURE,
        GLOBAL,
        DEFAULT,
        PROTO,
        WITH,
        UNKNOWN;

    }
}

