/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.actions;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.PersistentValues;
import org.netbeans.modules.debugger.jpda.truffle.TruffleDebugManager;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.source.Source;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RunToCursorActionProvider
extends ActionsProviderSupport {
    private static final String ACCESSOR_SET_ONE_SHOT_LINE_BREAKPOINT = "setOneShotLineBreakpoint";
    private static final String ACCESSOR_SET_ONE_SHOT_LINE_BREAKPOINT_SIGNAT = "(L" + String.class.getName().replace('.', '/') + ";I)[Lcom/oracle/truffle/api/debug/Breakpoint;";
    private final JPDADebugger debugger;
    private final Session session;
    private final PropertyChangeListener stateChangeListener;
    private volatile ArrayReference oneShotBreakpoint;

    public RunToCursorActionProvider(ContextProvider context) {
        this.debugger = (JPDADebugger)context.lookupFirst(null, JPDADebugger.class);
        this.session = (Session)context.lookupFirst(null, Session.class);
        this.stateChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RunToCursorActionProvider.this.checkEnabled();
            }
        };
        this.debugger.addPropertyChangeListener("state", this.stateChangeListener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/javascript", this.stateChangeListener);
        this.checkEnabled();
    }

    private void checkEnabled() {
        DebuggerEngine truffleDbgEngine = this.session.getEngineForLanguage("GraalVM_Script");
        if (truffleDbgEngine == null) {
            this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, false);
            return;
        }
        ActionsManager actionsManager = truffleDbgEngine.getActionsManager();
        int debuggerState = this.debugger.getState();
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, actionsManager.isEnabled(ActionsManager.ACTION_CONTINUE) && debuggerState == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".js"));
        if (debuggerState == 4) {
            this.debugger.removePropertyChangeListener("state", this.stateChangeListener);
            EditorContextDispatcher.getDefault().removePropertyChangeListener(this.stateChangeListener);
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        FileObject fo;
        if (this.oneShotBreakpoint != null) {
            this.removeBreakpoints(this.oneShotBreakpoint);
            this.oneShotBreakpoint = null;
        }
        if ((fo = EditorContextDispatcher.getDefault().getCurrentFile()) == null) {
            return;
        }
        URI uri = Source.getTruffleInternalURI(fo);
        if (uri == null) {
            uri = fo.toURI();
        }
        int line = EditorContextDispatcher.getDefault().getCurrentLineNumber();
        this.submitOneShotBreakpoint(uri.toString(), line);
        JPDAThread currentThread = this.debugger.getCurrentThread();
        if (currentThread != null) {
            currentThread.resume();
        }
    }

    private void submitOneShotBreakpoint(final String uri, final int line) {
        final ClassType debugAccessor = TruffleDebugManager.getDebugAccessorClass(this.debugger);
        try {
            final Method setLineBreakpointMethod = ClassTypeWrapper.concreteMethodByName((ClassType)debugAccessor, (String)ACCESSOR_SET_ONE_SHOT_LINE_BREAKPOINT, (String)ACCESSOR_SET_ONE_SHOT_LINE_BREAKPOINT_SIGNAT);
            TruffleAccess.methodCallingAccess(this.debugger, new TruffleAccess.MethodCallsAccess(){
                final /* synthetic */ RunToCursorActionProvider this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callMethods(JPDAThread thread) {
                    ThreadReference tr = ((JPDAThreadImpl)thread).getThreadReference();
                    PersistentValues persistents = new PersistentValues(tr.virtualMachine());
                    try {
                        ArrayReference ret;
                        StringReference pathRef = persistents.mirrorOf(uri);
                        IntegerValue lineRef = tr.virtualMachine().mirrorOf(line);
                        List<Value> args = Arrays.asList(pathRef, lineRef);
                        this.this$0.oneShotBreakpoint = ret = (ArrayReference)ClassTypeWrapper.invokeMethod((ClassType)debugAccessor, (ThreadReference)tr, (Method)setLineBreakpointMethod, args, (int)1);
                    }
                    catch (InvocationException iex) {
                        InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, (JPDADebuggerImpl)this.this$0.debugger).preload((JPDAThreadImpl)thread);
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Setting one shot breakpoint to " + uri + ":" + line)));
                    }
                    catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | UnsupportedOperationExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Setting one shot breakpoint to " + uri + ":" + line)));
                    }
                    finally {
                        persistents.collect();
                    }
                }
            });
        }
        catch (ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {
            // empty catch block
        }
    }

    private void removeBreakpoints(final ArrayReference bps) {
        final ClassType debugAccessor = TruffleDebugManager.getDebugAccessorClass(this.debugger);
        try {
            final Method removeLineBreakpointMethod = ClassTypeWrapper.concreteMethodByName((ClassType)debugAccessor, (String)"removeBreakpoint", (String)"(Ljava/lang/Object;)V");
            TruffleAccess.methodCallingAccess(this.debugger, new TruffleAccess.MethodCallsAccess(){
                final /* synthetic */ RunToCursorActionProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void callMethods(JPDAThread thread) {
                    ThreadReference tr = ((JPDAThreadImpl)thread).getThreadReference();
                    for (Value bpv : bps.getValues()) {
                        ObjectReference bp = (ObjectReference)bpv;
                        List<Value> args = Arrays.asList(bp);
                        try {
                            ClassTypeWrapper.invokeMethod((ClassType)debugAccessor, (ThreadReference)tr, (Method)removeLineBreakpointMethod, args, (int)1);
                        }
                        catch (InvocationException iex) {
                            InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, (JPDADebuggerImpl)this.this$0.debugger).preload((JPDAThreadImpl)thread);
                            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Removing one shot breakpoint " + String.valueOf(bp))));
                        }
                        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Removing one shot breakpoint " + String.valueOf(bp))));
                        }
                    }
                }
            });
        }
        catch (ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {
            // empty catch block
        }
    }
}

