/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.swing.JLabel;
import org.netbeans.modules.web.monitor.client.DataDisplay;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.data.CookieIn;
import org.netbeans.modules.web.monitor.data.CookieOut;
import org.netbeans.modules.web.monitor.data.CookiesData;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.openide.util.NbBundle;

public class CookieDisplay
extends DataDisplay {
    private static final boolean debug = false;

    public void setData(DataRecord md) {
        JLabel outgoingLabel;
        String headerOut;
        AccessibleRelation aRel;
        AccessibleContext aCtx;
        DisplayTable dt;
        JLabel incomingLabel;
        String headerIn;
        this.removeAll();
        if (md == null) {
            return;
        }
        CookiesData cd = md.getCookiesData();
        CookieIn[] in = cd.getCookieIn();
        CookieOut[] out = cd.getCookieOut();
        int gridy = -1;
        if (in == null || in.length == 0) {
            headerIn = NbBundle.getBundle(CookieDisplay.class).getString("MON_No_incoming");
            incomingLabel = CookieDisplay.createDataLabel(headerIn);
        } else {
            headerIn = NbBundle.getBundle(CookieDisplay.class).getString("MON_Incoming_cookie");
            incomingLabel = CookieDisplay.createHeaderLabel(headerIn, NbBundle.getBundle(CookieDisplay.class).getString("ACS_MON_Incoming_cookieA11yDesc"), null);
        }
        this.addGridBagComponent(this, CookieDisplay.createTopSpacer(), 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, topSpacerInsets, 0, 0);
        this.addGridBagComponent(this, incomingLabel, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 2, labelInsets, 0, 0);
        if (in != null && in.length > 0) {
            for (int i = 0; i < in.length; ++i) {
                String[] data = new String[]{in[i].getAttributeValue("name"), in[i].getAttributeValue("value")};
                String[] categoriesIn = new String[]{NbBundle.getBundle(CookieDisplay.class).getString("MON_Name"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Value")};
                dt = new DisplayTable(categoriesIn, data);
                aCtx = dt.getAccessibleContext();
                aCtx.setAccessibleName(NbBundle.getMessage(CookieDisplay.class, (String)"ACS_MON_Incoming_cookieTableA11yName"));
                aCtx.setAccessibleDescription(NbBundle.getMessage(CookieDisplay.class, (String)"ACS_MON_Incoming_cookieTableA11yDesc"));
                dt.setToolTipText(NbBundle.getMessage(CookieDisplay.class, (String)"ACS_MON_Incoming_cookieTableA11yDesc"));
                aRel = new AccessibleRelation(AccessibleRelation.LABELED_BY, incomingLabel);
                aCtx.getAccessibleRelationSet().add(aRel);
                this.addGridBagComponent(this, dt, 0, ++gridy, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
            }
        }
        if (out == null || out.length == 0) {
            headerOut = NbBundle.getBundle(CookieDisplay.class).getString("MON_No_outgoing");
            outgoingLabel = CookieDisplay.createDataLabel(headerOut);
        } else {
            headerOut = NbBundle.getBundle(CookieDisplay.class).getString("MON_Outgoing_cookie");
            outgoingLabel = CookieDisplay.createHeaderLabel(headerOut, NbBundle.getBundle(CookieDisplay.class).getString("ACS_MON_Outgoing_cookieA11yDesc"), null);
        }
        this.addGridBagComponent(this, outgoingLabel, 0, ++gridy, 0, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
        if (out != null && out.length > 0) {
            for (int i = 0; i < out.length; ++i) {
                String cookieMaxAge = out[i].getAttributeValue("maxAge");
                if (cookieMaxAge.equals("-1")) {
                    cookieMaxAge = NbBundle.getBundle(CookieDisplay.class).getString("MON_this_session");
                }
                String[] data = new String[]{out[i].getAttributeValue("name"), out[i].getAttributeValue("value"), out[i].getAttributeValue("domain"), out[i].getAttributeValue("path"), cookieMaxAge, out[i].getAttributeValue("version"), out[i].getAttributeValue("secure"), out[i].getAttributeValue("comment")};
                String[] categoriesOut = new String[]{NbBundle.getBundle(CookieDisplay.class).getString("MON_Name"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Value"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Domain"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Path"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Max_age"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Version"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Secure"), NbBundle.getBundle(CookieDisplay.class).getString("MON_Comment")};
                dt = new DisplayTable(categoriesOut, data);
                aCtx = dt.getAccessibleContext();
                aCtx.setAccessibleName(NbBundle.getMessage(CookieDisplay.class, (String)"ACS_MON_Outgoing_cookieTableA11yName"));
                aCtx.setAccessibleDescription(NbBundle.getMessage(CookieDisplay.class, (String)"ACS_MON_Outgoing_cookieTableA11yDesc"));
                dt.setToolTipText(NbBundle.getMessage(CookieDisplay.class, (String)"ACS_MON_Outgoing_cookieTableA11yDesc"));
                aRel = new AccessibleRelation(AccessibleRelation.LABELED_BY, outgoingLabel);
                aCtx.getAccessibleRelationSet().add(aRel);
                this.addGridBagComponent(this, dt, 0, ++gridy, 0, 1, 1.0, 0.0, 17, 1, tableInsets, 0, 0);
            }
        }
        this.addGridBagComponent(this, CookieDisplay.createGlue(), 0, ++gridy, 1, 1, 1.0, 1.0, 17, 1, zeroInsets, 0, 0);
        this.setMaximumSize(this.getPreferredSize());
        this.repaint();
    }
}

