/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tooltip;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tooltip.Tooltip;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class TooltipRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tooltip tooltip = (Tooltip)component;
        String target = SearchExpressionFacade.resolveComponentsForClient(context, component, tooltip.getFor());
        this.encodeMarkup(context, tooltip, target);
        this.encodeScript(context, tooltip, target);
    }

    protected void encodeMarkup(FacesContext context, Tooltip tooltip, String target) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (target != null) {
            String styleClass = tooltip.getStyleClass();
            styleClass = styleClass == null ? Tooltip.CONTAINER_CLASS : Tooltip.CONTAINER_CLASS + " " + styleClass;
            writer.startElement("div", (UIComponent)tooltip);
            writer.writeAttribute("id", (Object)tooltip.getClientId(context), null);
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            if (tooltip.getStyle() != null) {
                writer.writeAttribute("style", (Object)tooltip.getStyle(), "style");
            }
            if (tooltip.getChildCount() > 0) {
                this.renderChildren(context, (UIComponent)tooltip);
            } else {
                String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)tooltip);
                if (valueToRender != null) {
                    if (tooltip.isEscape()) {
                        writer.writeText((Object)valueToRender, "value");
                    } else {
                        writer.write(valueToRender);
                    }
                }
            }
            writer.endElement("div");
        }
    }

    protected void encodeScript(FacesContext context, Tooltip tooltip, String target) throws IOException {
        String clientId = tooltip.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Tooltip", tooltip.resolveWidgetVar(), clientId).attr("showEvent", tooltip.getShowEvent(), null).attr("hideEvent", tooltip.getHideEvent(), null).attr("showEffect", tooltip.getShowEffect(), null).attr("hideEffect", tooltip.getHideEffect(), null).attr("showDelay", tooltip.getShowDelay(), 150).attr("hideDelay", tooltip.getHideDelay(), 0).attr("target", target, null).attr("globalSelector", tooltip.getGlobalSelector(), null).attr("escape", tooltip.isEscape(), true).attr("trackMouse", tooltip.isTrackMouse(), false);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

