/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.action;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Modifier;

public final class GenerationOptions {
    private Operation operation;
    private String methodName;
    private String returnType;
    private String parameterName;
    private String parameterType;
    private String queryAttribute;
    private String annotationType;
    private Set<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC);

    public String getMethodName() {
        return this.methodName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public String getQueryAttribute() {
        return this.queryAttribute;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        EnumSet<Modifier> mod = EnumSet.noneOf(Modifier.class);
        mod.addAll(modifiers);
        this.modifiers = mod;
    }

    public String getCallLines() {
        return this.getCallLines(null, null);
    }

    public String getCallLines(String emName, String ecName) {
        return this.getCallLines(emName, ecName, "1.0");
    }

    public String getCallLines(String emName, String ecName, String version) {
        return this.operation == null ? null : MessageFormat.format(this.operation.getBody(version), emName, this.getParameterName(), this.getParameterType(), this.getReturnType(), this.getQueryAttribute(), ecName);
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setQueryAttribute(String queryAttribute) {
        this.queryAttribute = queryAttribute;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getAnnotation() {
        return this.annotationType;
    }

    public void setAnnotation(String annotationType) {
        this.annotationType = annotationType;
    }

    public static enum Operation {
        PERSIST("{0}.persist({1});"),
        MERGE("{0}.merge({1});"),
        REMOVE("{0}.remove({0}.merge({1}));"),
        FIND("return {0}.find({5}, {1});"),
        FIND_ALL("return {0}.createQuery(\"select object(o) from \" + {5}.getSimpleName() + \" as o\").getResultList();", "javax.persistence.criteria.CriteriaQuery cq = {0}.getCriteriaBuilder().createQuery();cq.select(cq.from({5}));return {0}.createQuery(cq).getResultList();", "jakarta.persistence.criteria.CriteriaQuery cq = {0}.getCriteriaBuilder().createQuery();cq.select(cq.from({5}));return {0}.createQuery(cq).getResultList();"),
        FIND_SUBSET("javax.persistence.Query q = {0}.createQuery(\"select object(o) from \" + {5}.getSimpleName() + \" as o\");\nq.setMaxResults({1}[1]-{1}[0]+1);\nq.setFirstResult({1}[0]);\nreturn q.getResultList();", "javax.persistence.criteria.CriteriaQuery cq = {0}.getCriteriaBuilder().createQuery();cq.select(cq.from({5}));javax.persistence.Query q = {0}.createQuery(cq);q.setMaxResults({1}[1]-{1}[0]+1);q.setFirstResult({1}[0]);return q.getResultList();", "jakarta.persistence.criteria.CriteriaQuery cq = {0}.getCriteriaBuilder().createQuery();cq.select(cq.from({5}));jakarta.persistence.Query q = {0}.createQuery(cq);q.setMaxResults({1}[1]-{1}[0]+1);q.setFirstResult({1}[0]);return q.getResultList();"),
        COUNT("return ((Long) {0}.createQuery(\"select count(o) from \" + {5}.getSimpleName() + \" as o\").getSingleResult()).intValue();", "javax.persistence.criteria.CriteriaQuery cq = {0}.getCriteriaBuilder().createQuery();javax.persistence.criteria.Root<{4}> rt = cq.from({5});cq.select({0}.getCriteriaBuilder().count(rt));javax.persistence.Query q = {0}.createQuery(cq);return ((Long) q.getSingleResult()).intValue();", "jakarta.persistence.criteria.CriteriaQuery cq = {0}.getCriteriaBuilder().createQuery();jakarta.persistence.criteria.Root<{4}> rt = cq.from({5});cq.select({0}.getCriteriaBuilder().count(rt));jakarta.persistence.Query q = {0}.createQuery(cq);return ((Long) q.getSingleResult()).intValue();"),
        GET_EM("return {0};");

        private final String body;
        private final String body2_0;
        private final String body3_0;
        private static final Comparator<String> JPA_VERSION_COMPARATOR;

        private Operation(String body) {
            this(body, body);
        }

        private Operation(String body, String body2_0) {
            this(body, body2_0, body2_0);
        }

        private Operation(String body, String body2_0, String body3_0) {
            this.body3_0 = body3_0;
            this.body2_0 = body2_0;
            this.body = body;
        }

        public String getBody() {
            return this.getBody("1.0");
        }

        public String getBody(String version) {
            if (version == null) {
                return this.body;
            }
            if (JPA_VERSION_COMPARATOR.compare(version, "3.0") >= 0) {
                return this.body3_0;
            }
            if (JPA_VERSION_COMPARATOR.compare(version, "2.0") >= 0) {
                return this.body2_0;
            }
            return this.body;
        }

        static {
            JPA_VERSION_COMPARATOR = (a, b) -> {
                String[] aComponents = a.split("\\D");
                String[] bComponents = b.split("\\D");
                for (int i = 0; i < Math.min(aComponents.length, bComponents.length); ++i) {
                    int numB;
                    int numA;
                    try {
                        numA = Integer.parseInt(aComponents[i]);
                    }
                    catch (NumberFormatException ex) {
                        numA = 0;
                    }
                    try {
                        numB = Integer.parseInt(bComponents[i]);
                    }
                    catch (NumberFormatException ex) {
                        numB = 0;
                    }
                    if (numA == numB) continue;
                    return numA - numB;
                }
                return 0;
            };
        }
    }
}

