/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold.ui;

import java.util.EventListener;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.fold.ui.FoldView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryChange;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class FoldViewFactory
extends EditorViewFactory
implements FoldHierarchyListener,
LookupListener,
PreferenceChangeListener {
    static final String DISPLAY_ALL_FOLDS_EXPANDED_PROPERTY = "display-all-folds-expanded";
    static final Logger CHANGE_LOG = Logger.getLogger("org.netbeans.editor.view.change");
    private static final Logger LOG = Logger.getLogger(FoldViewFactory.class.getName());
    private FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.textComponent());
    private boolean foldHierarchyLocked;
    private Fold fold;
    private int foldStartOffset;
    private Iterator<Fold> collapsedFoldIterator;
    private boolean displayAllFoldsExpanded;
    private boolean collapsedFoldEncountered;
    private FontColorSettings colorSettings;
    private Lookup.Result<FontColorSettings> colorSource;
    private Preferences prefs;
    private int viewFlags = 0;
    private final FoldHierarchyListener weakL = (FoldHierarchyListener)WeakListeners.create(FoldHierarchyListener.class, (EventListener)this, (Object)this.foldHierarchy);

    public static void register() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Fold view factory registered");
        }
        EditorViewFactory.registerFactory((EditorViewFactory.Factory)new FoldFactory());
    }

    public FoldViewFactory(View documentView) {
        super(documentView);
        this.foldHierarchy.addFoldHierarchyListener(this.weakL);
        this.foldHierarchy.lock();
        try {
            Iterator it = FoldUtilities.collapsedFoldIterator((FoldHierarchy)this.foldHierarchy, (int)0, (int)Integer.MAX_VALUE);
            this.collapsedFoldEncountered = it.hasNext();
        }
        finally {
            this.foldHierarchy.unlock();
        }
        this.displayAllFoldsExpanded = Boolean.TRUE.equals(this.textComponent().getClientProperty(DISPLAY_ALL_FOLDS_EXPANDED_PROPERTY));
        String mime = DocumentUtilities.getMimeType((Document)this.document());
        Lookup lkp = MimeLookup.getLookup((String)mime);
        this.colorSource = lkp.lookupResult(FontColorSettings.class);
        this.colorSource.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.colorSource));
        this.colorSettings = (FontColorSettings)this.colorSource.allInstances().iterator().next();
        this.prefs = (Preferences)lkp.lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs));
        this.initViewFlags();
    }

    private void initViewFlags() {
        this.viewFlags = (this.prefs.getBoolean("code-folding-content.preview", true) ? 1 : 0) | (this.prefs.getBoolean("code-folding-content.summary", true) ? 2 : 0);
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshColors();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        String k = evt.getKey();
        if ("code-folding-content.preview".equals(k) || "code-folding-content.summary".equals(k)) {
            this.initViewFlags();
            final Document d = this.document();
            if (d != null) {
                d.render(new Runnable(){
                    final /* synthetic */ FoldViewFactory this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        int end = d.getLength();
                        this.this$0.fireEvent(EditorViewFactoryChange.createList((int)0, (int)end, (EditorViewFactoryChange.Type)EditorViewFactoryChange.Type.CHARACTER_CHANGE));
                    }
                });
            }
        }
    }

    private void refreshColors() {
        this.colorSettings = (FontColorSettings)this.colorSource.allInstances().iterator().next();
        final Document d = this.document();
        if (d != null) {
            d.render(new Runnable(){
                final /* synthetic */ FoldViewFactory this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    int end = d.getLength();
                    this.this$0.fireEvent(EditorViewFactoryChange.createList((int)0, (int)end, (EditorViewFactoryChange.Type)EditorViewFactoryChange.Type.CHARACTER_CHANGE));
                }
            });
        }
    }

    public void restart(int startOffset, int endOffset, boolean createViews) {
        if (this.collapsedFoldEncountered) {
            Iterator it;
            this.foldHierarchy.lock();
            this.foldHierarchyLocked = true;
            this.collapsedFoldIterator = it = FoldUtilities.collapsedFoldIterator((FoldHierarchy)this.foldHierarchy, (int)startOffset, (int)Integer.MAX_VALUE);
            this.foldStartOffset = -1;
        }
    }

    private void updateFoldInfo(int offset) {
        if (this.foldStartOffset < offset) {
            while (this.collapsedFoldIterator.hasNext()) {
                this.fold = this.collapsedFoldIterator.next();
                this.foldStartOffset = this.fold.getStartOffset();
                int l = this.fold.getEndOffset() - this.foldStartOffset;
                if (this.foldStartOffset < offset || l <= 0) continue;
                return;
            }
            this.fold = null;
            this.foldStartOffset = Integer.MAX_VALUE;
        }
    }

    public int nextViewStartOffset(int offset) {
        if (!this.displayAllFoldsExpanded && this.collapsedFoldEncountered) {
            this.updateFoldInfo(offset);
            return this.foldStartOffset;
        }
        return Integer.MAX_VALUE;
    }

    public EditorView createView(int startOffset, int limitOffset, boolean forcedLimit, EditorView origView, int nextOrigViewOffset) {
        assert (startOffset == this.foldStartOffset) : "startOffset=" + startOffset + " != foldStartOffset=" + this.foldStartOffset;
        if (this.fold.getEndOffset() <= limitOffset || !forcedLimit) {
            return new FoldView(this.textComponent(), this.fold, this.colorSettings, this.viewFlags);
        }
        return null;
    }

    public int viewEndOffset(int startOffset, int limitOffset, boolean forcedLimit) {
        int foldEndOffset = this.fold.getEndOffset();
        if (foldEndOffset <= limitOffset) {
            return foldEndOffset;
        }
        return -1;
    }

    public void continueCreation(int startOffset, int endOffset) {
    }

    public void finishCreation() {
        this.fold = null;
        this.collapsedFoldIterator = null;
        if (this.foldHierarchyLocked) {
            this.foldHierarchy.unlock();
        }
    }

    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        int i;
        boolean collapsedAdded = false;
        boolean changedToCollapsed = false;
        for (i = evt.getAddedFoldCount() - 1; i >= 0; --i) {
            if (!evt.getAddedFold(i).isCollapsed()) continue;
            collapsedAdded = true;
            break;
        }
        if (!collapsedAdded) {
            for (i = evt.getFoldStateChangeCount() - 1; i >= 0; --i) {
                FoldStateChange foldStateChange = evt.getFoldStateChange(i);
                if (!foldStateChange.isCollapsedChanged() || !foldStateChange.getFold().isCollapsed()) continue;
                changedToCollapsed = true;
                break;
            }
        }
        this.collapsedFoldEncountered |= collapsedAdded || changedToCollapsed;
        JTextComponent comp = this.textComponent();
        if (this.collapsedFoldEncountered && comp != null) {
            int startOffset = evt.getAffectedStartOffset();
            int endOffset = evt.getAffectedEndOffset();
            if (CHANGE_LOG.isLoggable(Level.FINE)) {
                ViewUtils.log((Logger)CHANGE_LOG, (String)("CHANGE in FoldViewFactory: <" + startOffset + "," + endOffset + ">\n"));
            }
            if (collapsedAdded) {
                comp.putClientProperty("editorcaret.updateRetainsVisibleOnce", Boolean.TRUE);
            }
            this.fireEvent(EditorViewFactoryChange.createList((int)startOffset, (int)endOffset, (EditorViewFactoryChange.Type)EditorViewFactoryChange.Type.PARAGRAPH_CHANGE));
        }
    }

    public static final class FoldFactory
    implements EditorViewFactory.Factory {
        public EditorViewFactory createEditorViewFactory(View documentView) {
            return new FoldViewFactory(documentView);
        }

        public int weight() {
            return 100;
        }
    }
}

