/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.GetterSetterPanel;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.api.ui.JavaRefactoringActionsFactory;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class GetterSetterGenerator
implements CodeGenerator {
    private static final EnumSet<Tree.Kind> TREE_KINDS = EnumSet.copyOf(TreeUtilities.CLASS_TREE_KINDS);
    private final JTextComponent component;
    private final ElementNode.Description description;
    private final int type;
    private final CodeStyle codestyle;

    private GetterSetterGenerator(JTextComponent component, ElementNode.Description description, int type, CodeStyle codeStyle) {
        this.component = component;
        this.description = description;
        this.type = type;
        this.codestyle = codeStyle;
    }

    public String getDisplayName() {
        if (this.type == 1) {
            return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_getter");
        }
        if (this.type == 2) {
            return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_setter");
        }
        return NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_getter_and_setter");
    }

    public void invoke() {
        final int caretOffset = this.component.getCaretPosition();
        final GetterSetterPanel panel = new GetterSetterPanel(this.description, this.type);
        String title = this.type == 1 ? NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_getter") : (this.type == 2 ? NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_setter") : NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_getter_and_setter"));
        final DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, title);
        panel.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ GetterSetterGenerator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List<ElementHandle<? extends Element>> vars = panel.getVariables();
                dialogDescriptor.setValid(vars != null && !vars.isEmpty());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue()) {
            if (panel.isPerformEnsapsulate()) {
                this.performEncapsulate(panel.getVariables());
            } else {
                JavaSource js = JavaSource.forDocument((Document)this.component.getDocument());
                if (js != null) {
                    try {
                        ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){
                            final /* synthetic */ GetterSetterGenerator this$0;
                            {
                                this.this$0 = this$0;
                            }

                            public void run(WorkingCopy copy) throws IOException {
                                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                Element e = this.this$0.description.getElementHandle().resolve((CompilationInfo)copy);
                                TreePath path = e != null ? copy.getTrees().getPath(e) : copy.getTreeUtilities().pathFor(caretOffset);
                                path = copy.getTreeUtilities().getPathElementOfKind(TREE_KINDS, path);
                                if (path == null) {
                                    String message = NbBundle.getMessage(GetterSetterGenerator.class, (String)"ERR_CannotFindOriginalClass");
                                    Utilities.setStatusBoldText((JTextComponent)this.this$0.component, (String)message);
                                } else {
                                    ArrayList<VariableElement> variableElements = new ArrayList<VariableElement>();
                                    for (ElementHandle<? extends Element> elementHandle : panel.getVariables()) {
                                        VariableElement elem = (VariableElement)elementHandle.resolve((CompilationInfo)copy);
                                        if (elem == null) {
                                            String message = NbBundle.getMessage(GetterSetterGenerator.class, (String)"ERR_CannotFindOriginalMember");
                                            Utilities.setStatusBoldText((JTextComponent)this.this$0.component, (String)message);
                                            return;
                                        }
                                        variableElements.add(elem);
                                    }
                                    GeneratorUtils.generateGettersAndSetters(copy, path, variableElements, this.this$0.type, caretOffset);
                                }
                            }
                        });
                        GeneratorUtils.guardedCommit(this.component, mr);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private void performEncapsulate(final List<ElementHandle<? extends Element>> variables) {
        try {
            JavaSource js = JavaSource.forDocument((Document)this.component.getDocument());
            final ArrayList getters = new ArrayList();
            final ArrayList setters = new ArrayList();
            final ArrayList handles = new ArrayList(variables.size());
            js.runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ GetterSetterGenerator this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController parameter) throws Exception {
                    this.this$0.createGetterSetterLists(parameter, variables, handles, getters, setters, this.this$0.codestyle);
                }
            }, true);
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){
                final /* synthetic */ GetterSetterGenerator this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.doDefaultEncapsulate(handles, getters, setters);
                }
            }, (String)NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_EncapsulateFields"), (AtomicBoolean)new AtomicBoolean(), (boolean)false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void createGetterSetterLists(CompilationController cc, List<ElementHandle<? extends Element>> variables, List<? super TreePathHandle> handles, List<String> getters, List<String> setters, CodeStyle codestyle) {
        for (ElementHandle<? extends Element> handle : variables) {
            Element el = handle.resolve((CompilationInfo)cc);
            handles.add((TreePathHandle)TreePathHandle.create((Element)el, (CompilationInfo)cc));
            boolean isStatic = el.getModifiers().contains((Object)Modifier.STATIC);
            if (this.type != 1) {
                setters.add(CodeStyleUtils.computeSetterName((CharSequence)el.getSimpleName(), (boolean)isStatic, (CodeStyle)codestyle));
            } else {
                setters.add(null);
            }
            if (this.type != 2) {
                getters.add(CodeStyleUtils.computeGetterName((CharSequence)el.getSimpleName(), (el.asType().getKind() == TypeKind.BOOLEAN ? 1 : 0) != 0, (boolean)isStatic, (CodeStyle)codestyle));
                continue;
            }
            getters.add(null);
        }
    }

    private void doDefaultEncapsulate(List<TreePathHandle> variables, List<String> getters, List<String> setters) {
        RefactoringSession encapsulate = RefactoringSession.create((String)NbBundle.getMessage(GetterSetterGenerator.class, (String)"LBL_EncapsulateFields"));
        Iterator<String> setIterator = setters.iterator();
        Iterator<String> getIterator = getters.iterator();
        ClasspathInfo cpinfo = ClasspathInfo.create((Document)this.component.getDocument());
        Iterator<TreePathHandle> it = variables.iterator();
        while (it.hasNext()) {
            EncapsulateFieldRefactoring refactoring = new EncapsulateFieldRefactoring(it.next());
            refactoring.setSetterName(setIterator.next());
            refactoring.setGetterName(getIterator.next());
            refactoring.setFieldModifiers(EnumSet.of(Modifier.PRIVATE));
            refactoring.setMethodModifiers(EnumSet.of(Modifier.PUBLIC));
            Problem p = refactoring.prepare(encapsulate);
            if (p == null) continue;
            this.doFullEncapsulate();
            return;
        }
        encapsulate.doRefactoring(true);
    }

    private void doFullEncapsulate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Action encapsulateAction = JavaRefactoringActionsFactory.encapsulateFieldsAction().createContextAwareInstance(Lookups.fixed((Object[])new Object[]{((DataObject)GetterSetterGenerator.this.component.getDocument().getProperty("stream")).getNodeDelegate()}));
                encapsulateAction.actionPerformed(null);
            }
        });
    }

    static {
        TREE_KINDS.remove((Object)Tree.Kind.RECORD);
    }

    public static class Factory
    implements CodeGenerator.Factory {
        private static final String ERROR = "<error>";

        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<ElementNode.Description> descriptions;
            ArrayList<GetterSetterGenerator> ret = new ArrayList<GetterSetterGenerator>();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            if (component == null || controller == null) {
                return ret;
            }
            CodeStyle codeStyle = CodeStyle.getDefault((Document)component.getDocument());
            TreePath path = (TreePath)context.lookup(TreePath.class);
            path = controller.getTreeUtilities().getPathElementOfKind(TREE_KINDS, path);
            if (path == null) {
                return ret;
            }
            try {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ioe) {
                return ret;
            }
            Elements elements = controller.getElements();
            ElementUtilities eu = controller.getElementUtilities();
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (typeElement == null || !typeElement.getKind().isClass()) {
                return ret;
            }
            LinkedHashMap gDescriptions = new LinkedHashMap();
            LinkedHashMap sDescriptions = new LinkedHashMap();
            LinkedHashMap gsDescriptions = new LinkedHashMap();
            for (VariableElement variableElement : ElementFilter.fieldsIn(elements.getAllMembers(typeElement))) {
                List<ElementNode.Description> descriptions2;
                boolean hasSetter;
                if (ERROR.contentEquals(variableElement.getSimpleName())) continue;
                ElementNode.Description description = ElementNode.Description.create((CompilationInfo)controller, variableElement, null, true, false);
                boolean hasGetter = eu.hasGetter(typeElement, variableElement, codeStyle);
                boolean bl = hasSetter = variableElement.getModifiers().contains((Object)Modifier.FINAL) || eu.hasSetter(typeElement, variableElement, codeStyle);
                if (!hasGetter) {
                    descriptions2 = (ArrayList<ElementNode.Description>)gDescriptions.get(variableElement.getEnclosingElement());
                    if (descriptions2 == null) {
                        descriptions2 = new ArrayList<ElementNode.Description>();
                        gDescriptions.put(variableElement.getEnclosingElement(), descriptions2);
                    }
                    descriptions2.add(description);
                }
                if (!hasSetter) {
                    descriptions2 = (List)sDescriptions.get(variableElement.getEnclosingElement());
                    if (descriptions2 == null) {
                        descriptions2 = new ArrayList();
                        sDescriptions.put(variableElement.getEnclosingElement(), descriptions2);
                    }
                    descriptions2.add(description);
                }
                if (hasGetter || hasSetter) continue;
                descriptions2 = (List)gsDescriptions.get(variableElement.getEnclosingElement());
                if (descriptions2 == null) {
                    descriptions2 = new ArrayList();
                    gsDescriptions.put(variableElement.getEnclosingElement(), descriptions2);
                }
                descriptions2.add(description);
            }
            if (!gDescriptions.isEmpty()) {
                descriptions = new ArrayList<ElementNode.Description>();
                for (Map.Entry entry : gDescriptions.entrySet()) {
                    descriptions.add(ElementNode.Description.create((CompilationInfo)controller, (Element)entry.getKey(), (List)entry.getValue(), false, false));
                }
                Collections.reverse(descriptions);
                ret.add(new GetterSetterGenerator(component, ElementNode.Description.create((CompilationInfo)controller, typeElement, descriptions, false, false), 1, codeStyle));
            }
            if (!sDescriptions.isEmpty()) {
                descriptions = new ArrayList();
                for (Map.Entry entry : sDescriptions.entrySet()) {
                    descriptions.add(ElementNode.Description.create((CompilationInfo)controller, (Element)entry.getKey(), (List)entry.getValue(), false, false));
                }
                Collections.reverse(descriptions);
                ret.add(new GetterSetterGenerator(component, ElementNode.Description.create((CompilationInfo)controller, typeElement, descriptions, false, false), 2, codeStyle));
            }
            if (!gsDescriptions.isEmpty()) {
                descriptions = new ArrayList();
                for (Map.Entry entry : gsDescriptions.entrySet()) {
                    descriptions.add(ElementNode.Description.create((CompilationInfo)controller, (Element)entry.getKey(), (List)entry.getValue(), false, false));
                }
                Collections.reverse(descriptions);
                ret.add(new GetterSetterGenerator(component, ElementNode.Description.create((CompilationInfo)controller, typeElement, descriptions, false, false), 0, codeStyle));
            }
            return ret;
        }
    }
}

