/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.editor.base.options.MarkOccurencesSettingsNames;
import org.netbeans.modules.java.editor.base.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.base.semantic.MarkOccurrencesHighlighterBase;
import org.netbeans.modules.java.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.java.editor.semantic.ColoringManager;
import org.netbeans.modules.java.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class MarkOccurrencesHighlighter
extends MarkOccurrencesHighlighterBase {
    private FileObject file;
    public static final Color ES_COLOR = new Color(175, 172, 102);
    static ColoringAttributes.Coloring MO = ColoringAttributes.add((ColoringAttributes.Coloring)ColoringAttributes.empty(), (ColoringAttributes)ColoringAttributes.MARK_OCCURRENCES);

    MarkOccurrencesHighlighter(FileObject file) {
        this.file = file;
    }

    protected void process(CompilationInfo info, Document doc, SchedulerEvent event) {
        if (doc == null) {
            Logger.getLogger(MarkOccurrencesHighlighter.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return;
        }
        int caretPosition = event instanceof CursorMovedSchedulerEvent ? ((CursorMovedSchedulerEvent)event).getCaretOffset() : CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)this.file);
        Object prop = doc.getProperty("marked-occurrence");
        if (prop != null && ((long[])prop)[0] == DocumentUtilities.getDocumentVersion((Document)doc) && ((long[])prop)[1] == (long)caretPosition) {
            return;
        }
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        if (!node.getBoolean(MarkOccurencesSettingsNames.ON_OFF, true)) {
            MarkOccurrencesHighlighter.getHighlightsBag(doc).clear();
            OccurrencesMarkProvider.get(doc).setOccurrences(Collections.emptySet());
            return;
        }
        long start = System.currentTimeMillis();
        if (this.isCancelled()) {
            return;
        }
        ArrayList<int[]> bag = this.processImpl(info, node, doc, caretPosition);
        if (this.isCancelled()) {
            return;
        }
        Logger.getLogger("TIMER").log(Level.FINE, "Occurrences", new Object[]{NbEditorUtilities.getFileObject((Document)doc), System.currentTimeMillis() - start});
        if (bag == null) {
            if (node.getBoolean(MarkOccurencesSettingsNames.KEEP_MARKS, true)) {
                return;
            }
            bag = new ArrayList<int[]>();
        }
        bag.sort(new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o1[0] - o2[0];
            }
        });
        Iterator it = bag.iterator();
        int[] last = it.hasNext() ? (int[])it.next() : null;
        ArrayList<int[]> result = new ArrayList<int[]>(bag.size());
        while (it.hasNext()) {
            int[] current = (int[])it.next();
            if (current[0] < last[1]) {
                last[1] = Math.max(current[1], last[1]);
                continue;
            }
            result.add(last);
            last = current;
        }
        if (last != null) {
            result.add(last);
        }
        OffsetsBag obag = new OffsetsBag(doc);
        obag.clear();
        AttributeSet attributes = ColoringManager.getColoringImpl(MO);
        for (int[] span : result) {
            int convertedStart = info.getSnapshot().getOriginalOffset(span[0]);
            int convertedEnd = info.getSnapshot().getOriginalOffset(span[1]);
            if (convertedStart == -1 || convertedEnd == -1) continue;
            obag.addHighlight(convertedStart, convertedEnd, attributes);
        }
        if (this.isCancelled()) {
            return;
        }
        MarkOccurrencesHighlighter.getHighlightsBag(doc).setHighlights(obag);
        OccurrencesMarkProvider.get(doc).setOccurrences(OccurrencesMarkProvider.createMarks(doc, bag, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
    }

    static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(MarkOccurrencesHighlighter.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, false);
            doc.putProperty(MarkOccurrencesHighlighter.class, bag);
            Object stream = doc.getProperty("stream");
            final OffsetsBag bagFin = bag;
            DocumentListener l = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            doc.addDocumentListener(l);
            if (stream instanceof DataObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag", new Object[]{((DataObject)stream).getPrimaryFile(), bag});
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag Listener", new Object[]{((DataObject)stream).getPrimaryFile(), l});
            }
        }
        return bag;
    }
}

