/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RegionSubscription
extends ExplicitlySetBmcModel {
    @JsonProperty(value="regionKey")
    private final String regionKey;
    @JsonProperty(value="regionName")
    private final String regionName;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="isHomeRegion")
    private final Boolean isHomeRegion;

    @Deprecated
    @ConstructorProperties(value={"regionKey", "regionName", "status", "isHomeRegion"})
    public RegionSubscription(String regionKey, String regionName, Status status, Boolean isHomeRegion) {
        this.regionKey = regionKey;
        this.regionName = regionName;
        this.status = status;
        this.isHomeRegion = isHomeRegion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRegionKey() {
        return this.regionKey;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Status getStatus() {
        return this.status;
    }

    public Boolean getIsHomeRegion() {
        return this.isHomeRegion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RegionSubscription(");
        sb.append("super=").append(super.toString());
        sb.append("regionKey=").append(String.valueOf(this.regionKey));
        sb.append(", regionName=").append(String.valueOf(this.regionName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", isHomeRegion=").append(String.valueOf(this.isHomeRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegionSubscription)) {
            return false;
        }
        RegionSubscription other = (RegionSubscription)((Object)o);
        return Objects.equals(this.regionKey, other.regionKey) && Objects.equals(this.regionName, other.regionName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.isHomeRegion, other.isHomeRegion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.regionKey == null ? 43 : this.regionKey.hashCode());
        result = result * 59 + (this.regionName == null ? 43 : this.regionName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.isHomeRegion == null ? 43 : this.isHomeRegion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Ready("READY"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="regionKey")
        private String regionKey;
        @JsonProperty(value="regionName")
        private String regionName;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="isHomeRegion")
        private Boolean isHomeRegion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder regionKey(String regionKey) {
            this.regionKey = regionKey;
            this.__explicitlySet__.add("regionKey");
            return this;
        }

        public Builder regionName(String regionName) {
            this.regionName = regionName;
            this.__explicitlySet__.add("regionName");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder isHomeRegion(Boolean isHomeRegion) {
            this.isHomeRegion = isHomeRegion;
            this.__explicitlySet__.add("isHomeRegion");
            return this;
        }

        public RegionSubscription build() {
            RegionSubscription model = new RegionSubscription(this.regionKey, this.regionName, this.status, this.isHomeRegion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RegionSubscription model) {
            if (model.wasPropertyExplicitlySet("regionKey")) {
                this.regionKey(model.getRegionKey());
            }
            if (model.wasPropertyExplicitlySet("regionName")) {
                this.regionName(model.getRegionName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("isHomeRegion")) {
                this.isHomeRegion(model.getIsHomeRegion());
            }
            return this;
        }
    }
}

