/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RemoveUserFromGroupRequest
extends BmcRequest<Void> {
    private String userGroupMembershipId;
    private String ifMatch;

    public String getUserGroupMembershipId() {
        return this.userGroupMembershipId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().userGroupMembershipId(this.userGroupMembershipId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userGroupMembershipId=").append(String.valueOf(this.userGroupMembershipId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveUserFromGroupRequest)) {
            return false;
        }
        RemoveUserFromGroupRequest other = (RemoveUserFromGroupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userGroupMembershipId, other.userGroupMembershipId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userGroupMembershipId == null ? 43 : this.userGroupMembershipId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RemoveUserFromGroupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userGroupMembershipId = null;
        private String ifMatch = null;

        public Builder userGroupMembershipId(String userGroupMembershipId) {
            this.userGroupMembershipId = userGroupMembershipId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemoveUserFromGroupRequest o) {
            this.userGroupMembershipId(o.getUserGroupMembershipId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemoveUserFromGroupRequest build() {
            RemoveUserFromGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public RemoveUserFromGroupRequest buildWithoutInvocationCallback() {
            RemoveUserFromGroupRequest request = new RemoveUserFromGroupRequest();
            request.userGroupMembershipId = this.userGroupMembershipId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

