/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.MarshallerUtil;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.ResponseTransformer;
import com.sun.xml.registry.uddi.UDDIMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Processor {
    RegistryServiceImpl service;
    UDDIMapper mapper;
    ResponseTransformer transformer;
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });

    public Processor(RegistryServiceImpl registryService, UDDIMapper mapper) {
        this.service = registryService;
        this.mapper = mapper;
        this.transformer = new ResponseTransformer(mapper);
    }

    BulkResponse processRequestJAXB(Object obj, boolean secure, Collection keys, String type) throws JAXRException {
        SOAPMessage doc = null;
        try {
            doc = MarshallerUtil.getInstance().jaxbMarshalObject(obj);
        }
        catch (JAXBException jbe) {
            throw new JAXRException((Throwable)jbe);
        }
        return this.processResponseJAXB(this.service.send(doc, secure), keys, type);
    }

    BulkResponse processResponseJAXB(Node response, Collection keys, String type) throws JAXRException {
        BulkResponse bulkResponse = null;
        if (response == null) {
            return null;
        }
        Node resultNode = null;
        String name = response.getNodeName();
        if (((SOAPBody)response).hasFault()) {
            int listLength;
            NodeList list;
            if (response instanceof Element && (list = ((Element)response).getElementsByTagName("dispositionReport")) != null && (listLength = list.getLength()) > 0) {
                for (int i = 0; i < listLength; ++i) {
                    Node n = list.item(i);
                    if (n == null) continue;
                    resultNode = n;
                    name = "dispositionReport";
                    break;
                }
            }
        } else {
            resultNode = response.getFirstChild();
        }
        this.logger.finest("Node name " + name);
        try {
            Object obj = MarshallerUtil.getInstance().jaxbUnmarshalObject(resultNode);
            this.logger.finest("Class name " + obj.getClass().getName());
            bulkResponse = this.invokeMethod(obj, keys, type);
        }
        catch (JAXBException jbe) {
            throw new JAXRException((Throwable)jbe);
        }
        if (bulkResponse == null) {
            bulkResponse = new BulkResponseImpl();
        }
        return bulkResponse;
    }

    public BulkResponse invokeMethod(Object obj, Collection keys, String type) throws JAXRException {
        return this.transformer.transformResponse(obj, keys, type);
    }

    public BulkResponse invoke(Object obj, Collection keys, String type) throws InvocationTargetException, IllegalAccessException, JAXRException {
        Object[] args = new Object[]{obj, keys, type};
        Class[] classes = new Class[]{args[0].getClass(), Collection.class, String.class};
        try {
            Class<UDDIMapper> h = UDDIMapper.class;
            Method m = h.getMethod("transformResponse", classes);
            return (BulkResponse)m.invoke((Object)this.mapper, args);
        }
        catch (InvocationTargetException e) {
            Exception e1 = (Exception)e.getTargetException();
            throw new JAXRException((Throwable)e1);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e, ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDIMapper:Can't_find_method_"));
        }
    }
}

