/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.RootMethods;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class MiscInstrumentationOps
extends ClassManager {
    private List instrClasses = new ArrayList();
    private int nInstrClasses;
    private int nInstrMethods;

    public MiscInstrumentationOps(ProfilingSessionStatus status) {
        super(status);
    }

    public Object[] getOrigCodeForAllInstrumentedMethods() {
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        Enumeration e = ClassRepository.getClassEnumerationWithAllVersions();
        while (e.hasMoreElements()) {
            DynamicClassInfo clazz;
            Object ci = e.nextElement();
            if (!(ci instanceof DynamicClassInfo) || !(clazz = (DynamicClassInfo)ci).isLoaded() || !clazz.hasInstrumentedMethods()) continue;
            this.instrClasses.add(clazz);
            int nMethods = clazz.getMethodNames().length;
            int nLocalInstrMethods = 0;
            for (int i = 0; i < nMethods; ++i) {
                if (!clazz.isMethodInstrumented(i) || clazz.isMethodUnscannable(i)) continue;
                ++nLocalInstrMethods;
            }
            ++this.nInstrClasses;
            this.nInstrMethods += nLocalInstrMethods;
        }
        return this.createInstrumentedMethodPack();
    }

    Object[] getOrigCodeForSingleInstrumentedMethod(RootMethods rootMethods) {
        String className = rootMethods.classNames[0];
        String methodName = rootMethods.methodNames[0];
        String methodSignature = rootMethods.methodSignatures[0];
        List classes = ClassRepository.getAllClassVersions(className);
        if (classes == null) {
            return null;
        }
        methodName = methodName.intern();
        methodSignature = methodSignature.intern();
        this.nInstrMethods = 0;
        this.nInstrClasses = 0;
        for (int i = 0; i < classes.size(); ++i) {
            DynamicClassInfo clazz = (DynamicClassInfo)classes.get(i);
            int methodIdx = clazz.getMethodIndex(methodName, methodSignature);
            if (methodIdx == -1) continue;
            this.instrClasses.add(clazz);
            ++this.nInstrClasses;
            ++this.nInstrMethods;
        }
        if (this.nInstrClasses == 0) {
            MiscUtils.printErrorMessage("got zero classes when attempting to deinstrument a single instrumented method");
            return null;
        }
        return this.createInstrumentedMethodPack();
    }

    protected Object[] createInstrumentedMethodPack() {
        if (this.nInstrMethods == 0) {
            return null;
        }
        return this.createInstrumentedMethodPack15();
    }

    private Object[] createInstrumentedMethodPack15() {
        String[] instrMethodClasses = new String[this.nInstrClasses];
        int[] instrClassLoaderIds = new int[this.nInstrClasses];
        byte[][] replacementClassFileBytes = new byte[this.nInstrClasses][];
        for (int j = 0; j < this.nInstrClasses; ++j) {
            DynamicClassInfo clazz = (DynamicClassInfo)this.instrClasses.get(j);
            instrMethodClasses[j] = clazz.getName().replace('/', '.');
            instrClassLoaderIds[j] = clazz.getLoaderId();
        }
        return new Object[]{instrMethodClasses, instrClassLoaderIds, replacementClassFileBytes};
    }
}

