/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.checkout;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.subversion.util.CheckoutCompleted;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class CheckoutAction
implements ActionListener,
HelpCtx.Provider {
    private static final String WORKING_COPY_FORMAT_PROP = "svnkit.wc.17";

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.subversion.ui.checkout.CheckoutAction");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Utils.logVCSActionEvent((String)"SVN");
        CheckoutAction.performCheckout(false);
    }

    public static File performCheckout(final boolean wait) {
        assert (!wait || !EventQueue.isDispatchThread());
        CheckoutWizard wizard = new CheckoutWizard();
        if (!wizard.show()) {
            return null;
        }
        final SVNUrl repository = wizard.getRepositoryRoot();
        final RepositoryFile[] repositoryFiles = wizard.getRepositoryFiles();
        final File workDir = wizard.getWorkdir();
        final boolean atWorkingDirLevel = wizard.isAtWorkingDirLevel();
        final boolean doExport = wizard.isExport();
        final boolean showCheckoutCompleted = SvnModuleConfig.getDefault().getShowCheckoutCompleted();
        final boolean old16Format = wizard.isOldFormatPreferred();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                SvnClient client;
                final String oldPreference = System.getProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP);
                System.setProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP, Boolean.toString(!old16Format));
                try {
                    client = Subversion.getInstance().getClient(repository);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                    return;
                }
                RequestProcessor.Task t = CheckoutAction.performCheckout(repository, client, repositoryFiles, workDir, atWorkingDirLevel, doExport, showCheckoutCompleted);
                t.addTaskListener(new TaskListener(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void taskFinished(Task task) {
                        if (oldPreference == null) {
                            System.clearProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP);
                        } else {
                            System.setProperty(CheckoutAction.WORKING_COPY_FORMAT_PROP, oldPreference);
                        }
                    }
                });
                if (wait) {
                    t.waitFinished();
                }
            }
        };
        if (wait) {
            run.run();
        } else {
            Subversion.getInstance().getRequestProcessor().post(run);
        }
        return wizard.getWorkdir();
    }

    public static RequestProcessor.Task performCheckout(final SVNUrl repository, final SvnClient client, final RepositoryFile[] repositoryFiles, final File workingDir, final boolean atWorkingDirLevel, final boolean doExport, final boolean showCheckoutCompleted) {
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                try {
                    this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
                    this.setCancellableDelegate(client);
                    client.addNotifyListener(this);
                    CheckoutAction.checkout(client, repository, repositoryFiles, workingDir, atWorkingDirLevel, doExport, this);
                }
                catch (SVNClientException ex) {
                    this.annotate(ex);
                    return;
                }
                finally {
                    Subversion.getInstance().versionedFilesChanged();
                    client.removeNotifyListener(this);
                }
                if (this.isCanceled()) {
                    return;
                }
                this.setDisplayName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_ScanFolders_Progress"));
                if (showCheckoutCompleted) {
                    CheckoutAction.showCheckoutCompletet(repositoryFiles, workingDir, atWorkingDirLevel, doExport, this);
                }
            }
        };
        return support.start(Subversion.getInstance().getRequestProcessor(repository), repository, ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/checkout/Bundle").getString("LBL_Checkout_Progress"));
    }

    public static void checkout(final SvnClient client, SVNUrl repository, final RepositoryFile[] repositoryFiles, File workingDir, boolean atWorkingDirLevel, final boolean doExport, final SvnProgressSupport support) throws SVNClientException {
        final File[] destinations = new File[repositoryFiles.length];
        for (int i = 0; i < repositoryFiles.length; ++i) {
            File destination;
            if (!atWorkingDirLevel) {
                destination = new File(workingDir.getAbsolutePath() + "/" + repositoryFiles[i].getName());
                destination = FileUtil.normalizeFile((File)destination);
                destination.mkdir();
            } else {
                destination = workingDir;
            }
            destinations[i] = destination;
        }
        SvnUtils.runWithoutIndexing(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (int i = 0; i < repositoryFiles.length; ++i) {
                    File destination = destinations[i];
                    if (support != null && support.isCanceled()) {
                        return null;
                    }
                    if (doExport) {
                        client.doExport(repositoryFiles[i].getFileUrl(), destination, repositoryFiles[i].getRevision(), true);
                        continue;
                    }
                    client.checkout(repositoryFiles[i].getFileUrl(), destination, repositoryFiles[i].getRevision(), true);
                }
                return null;
            }
        }, destinations);
    }

    private static void showCheckoutCompletet(RepositoryFile[] repositoryFiles, File workingDir, boolean atWorkingDirLevel, boolean doExport, SvnProgressSupport support) {
        String[] folders;
        if (atWorkingDirLevel) {
            folders = new String[]{"."};
        } else {
            folders = new String[repositoryFiles.length];
            for (int i = 0; i < repositoryFiles.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                folders[i] = repositoryFiles[i].isRepositoryRoot() ? "." : repositoryFiles[i].getFileUrl().getLastPathSegment();
            }
        }
        CheckoutCompleted cc = new CheckoutCompleted(workingDir, folders);
        if (support != null && support.isCanceled()) {
            return;
        }
        cc.scanForProjects(support, doExport ? CheckoutCompleted.Type.EXPORT : CheckoutCompleted.Type.CHECKOUT);
    }
}

