/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.util.List;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.CommandRedeploy;
import org.netbeans.modules.payara.tooling.admin.RunnerHttp;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.utils.Utils;

public class RunnerHttpRedeploy
extends RunnerHttp {
    private static final String TARGET_PARAM = "target";
    private static final String NAME_PARAM = "name";
    private static final String CTXROOT_PARAM = "contextroot";
    private static final String PROPERTIES_PARAM = "properties";
    private static final String LIBRARIES_PARAM = "libraries";
    private static final String KEEP_STATE_PARAM = "keepState";
    private static final String HOT_DEPLOY_PARAM = "hotDeploy";
    private static final String METADATA_CHANGED_PARAM = "metadataChanged";
    private static final String SOURCES_CHANGED_PARAM = "sourcesChanged";
    final CommandRedeploy command;

    private static String query(Command command) {
        if (!(command instanceof CommandRedeploy)) {
            throw new CommandException("Illegal command instance provided");
        }
        CommandRedeploy redeploy = (CommandRedeploy)command;
        String name = Utils.sanitizeName(redeploy.name);
        String target = redeploy.target;
        String ctxRoot = redeploy.contextRoot;
        String keepState = Boolean.toString(redeploy.keepState);
        String hotDeploy = Boolean.toString(redeploy.hotDeploy);
        String metadataChanged = Boolean.toString(redeploy.metadataChanged);
        List<String> sourcesChanged = redeploy.sourcesChanged;
        StringBuilder sb = new StringBuilder(RunnerHttpRedeploy.queryPropertiesLength(redeploy.properties, PROPERTIES_PARAM) + RunnerHttpRedeploy.queryLibrariesLength(redeploy.libraries, LIBRARIES_PARAM) + (NAME_PARAM.length() + 1 + name.length()) + (target != null ? 1 + TARGET_PARAM.length() + 1 + target.length() : 0) + (ctxRoot != null && ctxRoot.length() > 0 ? 1 + CTXROOT_PARAM.length() + 1 + ctxRoot.length() : 0) + (redeploy.keepState ? KEEP_STATE_PARAM.length() + 1 + keepState.length() : 0) + (redeploy.hotDeploy ? HOT_DEPLOY_PARAM.length() + 1 + hotDeploy.length() : 0));
        sb.append(NAME_PARAM).append('=').append(name);
        if (target != null) {
            sb.append('&');
            sb.append(TARGET_PARAM).append('=').append(target);
        }
        if (ctxRoot != null && ctxRoot.length() > 0) {
            sb.append('&');
            sb.append(CTXROOT_PARAM).append('=').append(ctxRoot);
        }
        if (redeploy.keepState) {
            sb.append('&');
            sb.append(KEEP_STATE_PARAM);
            sb.append('=').append(keepState);
        }
        if (redeploy.hotDeploy) {
            sb.append('&');
            sb.append(HOT_DEPLOY_PARAM);
            sb.append('=').append(hotDeploy);
            if (redeploy.metadataChanged) {
                sb.append('&');
                sb.append(METADATA_CHANGED_PARAM);
                sb.append('=').append(metadataChanged);
            }
            if (!sourcesChanged.isEmpty()) {
                sb.append('&');
                sb.append(SOURCES_CHANGED_PARAM);
                sb.append('=').append(String.join((CharSequence)",", sourcesChanged));
            }
        }
        RunnerHttpRedeploy.queryPropertiesAppend(sb, redeploy.properties, PROPERTIES_PARAM, true);
        RunnerHttpRedeploy.queryLibrariesAppend(sb, redeploy.libraries, LIBRARIES_PARAM, true);
        return sb.toString();
    }

    public RunnerHttpRedeploy(PayaraServer server, Command command) {
        super(server, command, RunnerHttpRedeploy.query(command));
        this.command = (CommandRedeploy)command;
    }
}

