/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.history;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.versioning.history.SummaryCellRenderer;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public abstract class AbstractSummaryView
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.versioning.util.AbstractSummaryView");
    public static final String PROP_REVISIONS_ADDED = "propRevisionsAdded";
    private final PropertyChangeListener list;
    private final ExpandCollapseGeneralAction expandCollapseAction;
    private JList<Item> resultsList;
    private final JScrollPane scrollPane;
    private final VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();
    private static final int NEXT_FILES_INITIAL_PAGING = 50;
    private final SummaryViewMaster master;

    public AbstractSummaryView(SummaryViewMaster master, List<? extends LogEntry> results) {
        this.master = master;
        this.list = WeakListeners.propertyChange((PropertyChangeListener)this, null);
        this.resultsList = new JList(new DefaultListModel());
        this.resultsList.setModel(new SummaryListModel(results, master.hasMoreResults()));
        this.resultsList.setCellRenderer(new SummaryCellRenderer(this, this.linkerSupport));
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AbstractSummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AbstractSummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        this.resultsList.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractSummaryView.this.refreshView(false);
            }
        });
        this.resultsList.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.resultsList.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Point p = Utils.getPositionForPopup(AbstractSummaryView.this.resultsList);
                Object[] selection = AbstractSummaryView.this.getSelection();
                if (selection.length > 0) {
                    AbstractSummaryView.this.onPopup(AbstractSummaryView.this.resultsList, p, selection);
                }
            }
        });
        ExpandAction expand = new ExpandAction();
        CollapseAction collapse = new CollapseAction();
        this.expandCollapseAction = new ExpandCollapseGeneralAction(expand, collapse);
        this.resultsList.getActionMap().put("selectNextColumn", expand);
        this.resultsList.getActionMap().put("selectPreviousColumn", collapse);
        this.resultsList.getActionMap().put("addToSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Item> selection = AbstractSummaryView.this.resultsList.getSelectedValuesList();
                if (selection.size() == 1) {
                    if (selection.get(0) instanceof ShowAllEventsItem) {
                        AbstractSummaryView.this.showRemainingFiles(((ShowAllEventsItem)selection.get(0)).getParent(), true);
                    } else if (selection.get(0) instanceof ShowLessEventsItem) {
                        AbstractSummaryView.this.showRemainingFiles(((ShowLessEventsItem)selection.get(0)).getParent(), false);
                    } else if (selection.get(0) instanceof MoreRevisionsItem) {
                        AbstractSummaryView.this.moreRevisions(10);
                    }
                }
            }
        });
        this.scrollPane.validate();
    }

    private List<Item> initializeResults(List<? extends LogEntry> results, boolean hasMoreResults) {
        List<Item> toDisplay = this.expandResults(results);
        if (hasMoreResults) {
            toDisplay.add(new MoreRevisionsItem());
        }
        return toDisplay;
    }

    private List<Item> expandResults(List<? extends LogEntry> results) {
        ArrayList<Item> newResults = new ArrayList<Item>(results.size() * 6);
        for (LogEntry logEntry : results) {
            logEntry.removePropertyChangeListener("propEventsChanged", this.list);
            logEntry.addPropertyChangeListener("propEventsChanged", this.list);
            RevisionItem item = new RevisionItem(logEntry);
            newResults.add(item);
            newResults.add(new ActionsItem(item));
            if (logEntry.isEventsInitialized()) continue;
            newResults.add(new LoadingEventsItem(item));
        }
        return newResults;
    }

    public final void requestFocusInWindow() {
        this.resultsList.requestFocusInWindow();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.expandCollapseAction.actionPerformed(new ActionEvent(this.resultsList, 1001, null));
        } else {
            int idx = this.resultsList.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            Rectangle rect = this.resultsList.getCellBounds(idx, idx);
            Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
            this.linkerSupport.mouseClicked(p, this.getLinkerIdentFor(idx));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
        this.resultsList.setToolTipText(null);
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        this.linkerSupport.mouseMoved(p, this.resultsList, this.getLinkerIdentFor(idx));
    }

    String getLinkerIdentFor(int index) {
        Item item = ((SummaryListModel)this.resultsList.getModel()).getElementAt(index);
        return item.getItemId();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public final void refreshView() {
        this.refreshView(true);
    }

    private void refreshView(boolean refreshModel) {
        ListCellRenderer<Item> r = this.resultsList.getCellRenderer();
        this.resultsList.setCellRenderer(null);
        this.resultsList.setCellRenderer(r);
        if (refreshModel) {
            ((SummaryListModel)this.resultsList.getModel()).refreshModel();
        }
        this.scrollPane.revalidate();
    }

    private void onPopup(MouseEvent e) {
        Object[] selection = this.getSelection(e.getPoint());
        if (selection.length > 0) {
            this.onPopup(this.resultsList, e.getPoint(), selection);
        }
    }

    protected abstract void onPopup(JComponent var1, Point var2, Object[] var3);

    protected final Object[] getSelection() {
        List<Item> sel = this.resultsList.getSelectedValuesList();
        Object[] selection = new Object[sel.size()];
        for (int i = 0; i < sel.size(); ++i) {
            Item item = sel.get(i);
            Object o = item.getUserData();
            if (o == null) {
                return new Object[0];
            }
            selection[i] = o;
        }
        return selection;
    }

    private Object[] getSelection(Point p) {
        int[] selected = this.resultsList.getSelectedIndices();
        int idx = this.resultsList.locationToIndex(p);
        if (idx == -1) {
            return new Object[0];
        }
        boolean contains = false;
        for (int i : selected) {
            if (i != idx) continue;
            contains = true;
            break;
        }
        if (!contains) {
            this.resultsList.setSelectedIndex(idx);
        }
        return this.getSelection();
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    File getRoot() {
        if (this.master.getRoots() == null || this.master.getRoots().length == 0) {
            return null;
        }
        return this.master.getRoots()[0];
    }

    Map<String, String> getActionColors() {
        return this.master.getActionColors();
    }

    SummaryViewMaster getMaster() {
        return this.master;
    }

    void itemChanged(Point p) {
        int index = this.resultsList.locationToIndex(p);
        if (index != -1) {
            ((SummaryListModel)this.resultsList.getModel()).fireChange(index);
            ((SummaryListModel)this.resultsList.getModel()).refreshModel();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("propEventsChanged".equals(evt.getPropertyName())) {
            LogEntry src = (LogEntry)evt.getSource();
            this.refreshEvents(src);
        }
    }

    private void refreshEvents(LogEntry src) {
        Mutex.EVENT.readAccess(() -> ((SummaryListModel)this.resultsList.getModel()).addEvents(src));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showRemainingFiles(RevisionItem item, boolean showMore) {
        assert (EventQueue.isDispatchThread());
        JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
        Cursor cursor = mainWindow.getCursor();
        try {
            if (showMore) {
                item.showMoreFiles();
            } else {
                item.showLessFiles();
            }
            mainWindow.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            mainWindow.getGlassPane().setVisible(true);
            ((SummaryListModel)this.resultsList.getModel()).refreshModel();
            if (this.resultsList.getSelectedIndices().length == 1) {
                this.resultsList.ensureIndexIsVisible(this.resultsList.getSelectedIndices()[0]);
            }
        }
        finally {
            mainWindow.getGlassPane().setCursor(cursor);
            mainWindow.getGlassPane().setVisible(false);
        }
    }

    void moreRevisions(Integer count) {
        this.master.getMoreResults(this, count);
    }

    public void entriesChanged(List<? extends LogEntry> entries) {
        Mutex.EVENT.readAccess(() -> {
            List<Item> selection = this.resultsList.getSelectedValuesList();
            if (selection.size() > 0 && selection.get(selection.size() - 1) instanceof MoreRevisionsItem) {
                int lastIndex = ((SummaryListModel)this.resultsList.getModel()).getSize() - 1;
                this.resultsList.getSelectionModel().removeIndexInterval(lastIndex, lastIndex);
            }
            ((SummaryListModel)this.resultsList.getModel()).addEntries(entries, !this.master.hasMoreResults());
        });
    }

    public static interface SummaryViewMaster {
        public JComponent getComponent();

        public File[] getRoots();

        public Collection<SearchHighlight> getSearchHighlights();

        public Map<String, String> getActionColors();

        public void getMoreResults(PropertyChangeListener var1, int var2);

        public boolean hasMoreResults();

        public static final class SearchHighlight {
            private final Kind kind;
            private final String searchText;

            public SearchHighlight(Kind kind, String searchText) {
                this.kind = kind;
                this.searchText = searchText.toLowerCase();
            }

            public Kind getKind() {
                return this.kind;
            }

            public String getSearchText() {
                return this.searchText;
            }

            public boolean equals(Object obj) {
                boolean eq = false;
                if (obj instanceof SearchHighlight) {
                    boolean bl = eq = this.kind == ((SearchHighlight)obj).kind;
                    if (eq) {
                        eq = this.searchText.equals(((SearchHighlight)obj).searchText);
                    }
                }
                return eq;
            }

            public int hashCode() {
                int hash = 5;
                hash = 17 * hash + (this.kind != null ? this.kind.hashCode() : 0);
                hash = 17 * hash + (this.searchText != null ? this.searchText.hashCode() : 0);
                return hash;
            }

            public static enum Kind {
                MESSAGE,
                AUTHOR,
                REVISION,
                FILE;

            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private final Set<String> revisions;
        private final List<Item> allResults;
        private final List<Item> dispResults;

        public SummaryListModel(List<? extends LogEntry> entries, boolean hasMoreResults) {
            this.allResults = new ArrayList<Item>(AbstractSummaryView.this.initializeResults(entries, AbstractSummaryView.this.master.hasMoreResults()));
            this.dispResults = new ArrayList<Item>(this.allResults.size());
            this.revisions = new HashSet<String>();
            for (LogEntry logEntry : entries) {
                this.revisions.add(logEntry.getRevision());
            }
            this.refreshModel();
        }

        @Override
        public int getSize() {
            return this.dispResults.size();
        }

        @Override
        public Item getElementAt(int index) {
            return this.dispResults.get(index);
        }

        void addEvents(LogEntry src) {
            assert (EventQueue.isDispatchThread());
            RevisionItem rev = null;
            ListIterator<Item> it = this.allResults.listIterator();
            block0: while (it.hasNext()) {
                Item revCandidate = it.next();
                if (!(revCandidate instanceof RevisionItem) || revCandidate.getUserData() != src) continue;
                rev = (RevisionItem)revCandidate;
                if (!it.hasNext()) break;
                if (it.next() instanceof ActionsItem) {
                    while (it.hasNext()) {
                        Item item = it.next();
                        if (item instanceof EventItem || item instanceof LoadingEventsItem) {
                            item.setVisible(false);
                            it.remove();
                            continue;
                        }
                        it.previous();
                        break block0;
                    }
                    break;
                }
                it.previous();
                break;
            }
            if (rev != null) {
                rev.viewEventsInitialized = true;
                Collection<LogEntry.Event> events = src.getEvents();
                for (LogEntry.Event ev : events) {
                    it.add(new EventItem(ev, rev));
                }
                it.add(new ShowAllEventsItem(rev));
                it.add(new ShowLessEventsItem(rev));
            }
            this.refreshModel();
        }

        void addDummyEvents(LogEntry src) {
            assert (EventQueue.isDispatchThread());
            RevisionItem rev = null;
            ListIterator<Item> it = this.allResults.listIterator();
            while (it.hasNext()) {
                Item revCandidate = it.next();
                if (!(revCandidate instanceof RevisionItem) || revCandidate.getUserData() != src) continue;
                rev = (RevisionItem)revCandidate;
                if (!it.hasNext() || it.next() instanceof ActionsItem) break;
                it.previous();
                break;
            }
            if (rev != null) {
                Collection<LogEntry.Event> events = src.getDummyEvents();
                for (LogEntry.Event ev : events) {
                    it.add(new EventItem(ev, rev));
                }
            }
            this.refreshModel();
        }

        private void addEntries(List<? extends LogEntry> entries, boolean noMoreResults) {
            LinkedList<? extends LogEntry> newEntries = new LinkedList<LogEntry>(entries);
            newEntries.removeIf(entry -> !this.revisions.add(entry.getRevision()));
            List<Item> itemsToAdd = AbstractSummaryView.this.expandResults(newEntries);
            if (!itemsToAdd.isEmpty()) {
                int addedAtIndex = this.allResults.get(this.allResults.size() - 1) instanceof MoreRevisionsItem ? this.allResults.size() - 1 : this.allResults.size();
                this.allResults.addAll(addedAtIndex, itemsToAdd);
            }
            if (noMoreResults && !this.allResults.isEmpty() && this.allResults.get(this.allResults.size() - 1) instanceof MoreRevisionsItem) {
                ((MoreRevisionsItem)this.allResults.remove(this.allResults.size() - 1)).setVisible(false);
            }
            this.refreshModel();
        }

        private void refreshModel() {
            int index = 0;
            Iterator<Item> it = this.dispResults.listIterator();
            while (it.hasNext()) {
                if (it.next().isVisible()) {
                    ++index;
                    continue;
                }
                it.remove();
                this.fireIntervalRemoved(it, index, index);
            }
            if (this.dispResults.isEmpty()) {
                for (Item item : this.allResults) {
                    if (!item.isVisible()) continue;
                    this.dispResults.add(item);
                }
                this.fireIntervalAdded(this, 0, this.dispResults.size());
            } else {
                this.dispResults.add(new MoreRevisionsItem());
                ListIterator<Item> dispIterator = this.dispResults.listIterator();
                Item displayed = dispIterator.next();
                index = 0;
                int addedStart = -1;
                int addedLast = 0;
                int removedStart = -1;
                int removedLast = 0;
                for (Item item : this.allResults) {
                    if (item == displayed) {
                        this.fireAdds(addedStart, addedLast);
                        addedStart = -1;
                        addedLast = 0;
                        if (!item.isVisible()) {
                            dispIterator.remove();
                            if (removedStart == -1) {
                                removedStart = removedLast = index;
                            } else if (removedLast < index - 1) {
                                this.fireRemovals(removedStart, removedLast);
                                removedStart = index;
                            } else {
                                removedLast = index;
                            }
                        }
                        if (!dispIterator.hasNext()) continue;
                        displayed = dispIterator.next();
                        ++index;
                        continue;
                    }
                    this.fireRemovals(removedStart, removedLast);
                    removedStart = -1;
                    removedLast = 0;
                    if (!item.isVisible()) continue;
                    dispIterator.previous();
                    dispIterator.add(item);
                    if (addedStart == -1) {
                        addedStart = addedLast = index;
                    } else if (addedLast < index - 1) {
                        this.fireAdds(addedStart, addedLast);
                        addedStart = index;
                    } else {
                        addedLast = index;
                    }
                    dispIterator.next();
                    ++index;
                }
                this.fireAdds(addedStart, addedLast);
                this.dispResults.remove(this.dispResults.size() - 1);
            }
        }

        private void fireChange(int index) {
            this.fireContentsChanged(this, index, index);
        }

        private void fireAdds(int start, int end) {
            if (start != -1 && end >= start) {
                this.fireIntervalAdded(this, start, end);
                for (int i = start; i <= end; ++i) {
                    if (!AbstractSummaryView.this.resultsList.getSelectionModel().isSelectedIndex(i)) continue;
                    AbstractSummaryView.this.resultsList.getSelectionModel().removeSelectionInterval(i, i);
                }
            }
        }

        private void fireRemovals(int start, int end) {
            if (start != -1 && end >= start) {
                this.fireIntervalRemoved(this, start, end);
            }
        }
    }

    private class ExpandAction
    extends ExpandCollapseAction {
        private ExpandAction() {
        }

        @Override
        protected void perform(RevisionItem revisionItem) {
            if (!revisionItem.revisionExpanded) {
                revisionItem.setExpanded(true);
                ((SummaryListModel)AbstractSummaryView.this.resultsList.getModel()).refreshModel();
            }
        }
    }

    private class CollapseAction
    extends ExpandCollapseAction {
        private CollapseAction() {
        }

        @Override
        protected void perform(RevisionItem revisionItem) {
            if (revisionItem.revisionExpanded) {
                revisionItem.setExpanded(false);
                ((SummaryListModel)AbstractSummaryView.this.resultsList.getModel()).refreshModel();
            }
        }
    }

    private class ExpandCollapseGeneralAction
    extends ExpandCollapseAction {
        private final ExpandCollapseAction collapseAction;
        private final ExpandCollapseAction expandAction;

        public ExpandCollapseGeneralAction(ExpandCollapseAction expandAction, ExpandCollapseAction collapseAction) {
            this.expandAction = expandAction;
            this.collapseAction = collapseAction;
        }

        @Override
        protected void perform(RevisionItem revisionItem) {
            if (revisionItem.revisionExpanded) {
                this.collapseAction.perform(revisionItem);
            } else {
                this.expandAction.perform(revisionItem);
            }
        }
    }

    private abstract class ExpandCollapseAction
    extends AbstractAction {
        private ExpandCollapseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Item> selection = AbstractSummaryView.this.resultsList.getSelectedValuesList();
            if (selection.size() == 1 && selection.get(0) instanceof RevisionItem) {
                this.perform((RevisionItem)selection.get(0));
            }
        }

        protected abstract void perform(RevisionItem var1);
    }

    class MoreRevisionsItem
    extends Item {
        public MoreRevisionsItem() {
            super(null);
        }

        @Override
        String getItemId() {
            return "#MoreRevisions";
        }
    }

    public static abstract class LogEntry {
        public static final String PROP_EVENTS_CHANGED = "propEventsChanged";
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);

        public abstract Collection<Event> getEvents();

        public Collection<Event> getDummyEvents() {
            return Collections.emptyList();
        }

        public abstract String getAuthor();

        public abstract String getDate();

        public abstract String getRevision();

        public abstract String getMessage();

        public abstract Action[] getActions();

        public abstract boolean isVisible();

        protected final void eventsChanged(List<? extends Event> oldEvents, List<? extends Event> newEvents) {
            this.support.firePropertyChange(PROP_EVENTS_CHANGED, oldEvents, newEvents);
        }

        public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(propertyName, listener);
        }

        public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(propertyName, listener);
        }

        protected abstract void cancelExpand();

        protected abstract void expand();

        protected abstract boolean isEventsInitialized();

        protected abstract boolean isLessInteresting();

        protected abstract Collection<RevisionHighlight> getRevisionHighlights();

        public static final class RevisionHighlight {
            private final int start;
            private final int length;
            private final Color foreground;
            private final Color background;

            public RevisionHighlight(int start, int length, Color foreground, Color background) {
                this.start = start;
                this.length = length;
                this.foreground = foreground;
                this.background = background;
            }

            public Color getBackground() {
                return this.background;
            }

            public int getLength() {
                return this.length;
            }

            public Color getForeground() {
                return this.foreground;
            }

            public int getStart() {
                return this.start;
            }
        }

        public static abstract class Event {
            public abstract String getPath();

            public abstract String getOriginalPath();

            public abstract String getAction();

            public abstract Action[] getUserActions();

            public abstract boolean isVisibleByDefault();
        }
    }

    class RevisionItem
    extends Item<LogEntry> {
        private final LogEntry entry;
        MaxPathWidth maxPathWidth;
        boolean messageExpanded;
        boolean revisionExpanded;
        private boolean viewEventsInitialized;
        private boolean initializingStarted;
        int showingFiles;
        private int nextFilesPaging;

        public RevisionItem(LogEntry entry) {
            super(entry);
            this.maxPathWidth = null;
            this.nextFilesPaging = 50;
            this.entry = entry;
        }

        @Override
        String getItemId() {
            return this.entry.getRevision();
        }

        @Override
        boolean isVisible() {
            return this.entry.isVisible();
        }

        private boolean isAllEventsVisible() {
            return this.revisionExpanded && this.showingFiles == -1;
        }

        public String toString() {
            return this.entry.toString();
        }

        void setExpanded(boolean expanded) {
            this.revisionExpanded = expanded;
            if (this.revisionExpanded) {
                if (this.entry.isEventsInitialized()) {
                    if (!this.viewEventsInitialized) {
                        this.showLessFiles();
                        ((SummaryListModel)AbstractSummaryView.this.resultsList.getModel()).addEvents((LogEntry)this.getUserData());
                    }
                } else {
                    this.entry.expand();
                    if (!this.initializingStarted) {
                        this.initializingStarted = true;
                        ((SummaryListModel)AbstractSummaryView.this.resultsList.getModel()).addDummyEvents((LogEntry)this.getUserData());
                    }
                }
            }
        }

        private boolean canShowLessEvents() {
            return this.revisionExpanded && this.showingFiles > 50 || this.isAllEventsVisible() && Math.min(50, this.getDefaultVisibleEventCount()) < this.entry.getEvents().size();
        }

        int getNextFilesToShowCount() {
            int cnt = this.entry.getEvents().size() - this.showingFiles;
            cnt = cnt <= this.nextFilesPaging ? -1 : this.nextFilesPaging;
            return cnt;
        }

        private void showMoreFiles() {
            int nextFiles = this.getNextFilesToShowCount();
            if (nextFiles > 0) {
                this.showingFiles += nextFiles;
                this.nextFilesPaging *= 2;
            } else {
                this.showingFiles = -1;
            }
        }

        private void showLessFiles() {
            this.showingFiles = Math.min(50, this.getDefaultVisibleEventCount());
            this.nextFilesPaging = 50;
        }

        boolean isEventVisible(EventItem event) {
            return this.isEventVisible((LogEntry.Event)event.getUserData());
        }

        boolean isEventVisible(LogEntry.Event event) {
            if (!this.viewEventsInitialized || this.isAllEventsVisible()) {
                return true;
            }
            if (this.showingFiles == 0) {
                this.showLessFiles();
                if (this.entry.getEvents().size() == this.getDefaultVisibleEventCount() && this.entry.getEvents().size() <= this.nextFilesPaging) {
                    this.showingFiles = -1;
                    return true;
                }
            }
            int visibleCount = 0;
            block0: for (boolean defaultVisible : new boolean[]{true, false}) {
                for (LogEntry.Event e : this.entry.getEvents()) {
                    if (visibleCount >= this.showingFiles) continue block0;
                    if (e.isVisibleByDefault() != defaultVisible) continue;
                    ++visibleCount;
                    if (e != event) continue;
                    return true;
                }
            }
            return false;
        }

        private int getDefaultVisibleEventCount() {
            int i = 0;
            for (LogEntry.Event e : this.entry.getEvents()) {
                if (!e.isVisibleByDefault()) continue;
                ++i;
            }
            return i;
        }
    }

    class ActionsItem
    extends Item {
        private final RevisionItem parent;

        public ActionsItem(RevisionItem parent) {
            super(parent.getUserData());
            this.parent = parent;
        }

        @Override
        String getItemId() {
            return this.parent.getItemId() + "#ACTIONS";
        }

        @Override
        boolean isVisible() {
            return this.parent.isVisible() && this.parent.revisionExpanded && ((LogEntry)this.parent.getUserData()).getActions().length > 0;
        }

        RevisionItem getParent() {
            return this.parent;
        }
    }

    class LoadingEventsItem
    extends Item {
        private final RevisionItem parent;

        public LoadingEventsItem(RevisionItem parent) {
            super(null);
            this.parent = parent;
        }

        @Override
        String getItemId() {
            return this.parent.getItemId() + "#LOADING_EVENTS";
        }

        @Override
        boolean isVisible() {
            return super.isVisible() && this.parent.isVisible() && this.parent.revisionExpanded;
        }
    }

    abstract class Item<T> {
        private final T userData;
        private boolean visible = true;

        Item(T userData) {
            this.userData = userData;
        }

        final T getUserData() {
            return this.userData;
        }

        boolean isVisible() {
            return this.visible;
        }

        void setVisible(boolean visible) {
            this.visible = visible;
        }

        abstract String getItemId();
    }

    class ShowLessEventsItem
    extends Item {
        private final RevisionItem parent;

        public ShowLessEventsItem(RevisionItem parent) {
            super(null);
            this.parent = parent;
        }

        @Override
        String getItemId() {
            return this.parent.getItemId() + "#SHOW_LESS_FILES";
        }

        @Override
        boolean isVisible() {
            return this.parent.isVisible() && this.parent.revisionExpanded && this.parent.canShowLessEvents();
        }

        RevisionItem getParent() {
            return this.parent;
        }
    }

    class ShowAllEventsItem
    extends Item {
        private final RevisionItem parent;

        public ShowAllEventsItem(RevisionItem parent) {
            super(null);
            this.parent = parent;
        }

        @Override
        String getItemId() {
            return this.parent.getItemId() + "#SHOW_ALL_FILES";
        }

        @Override
        boolean isVisible() {
            return this.parent.isVisible() && this.parent.revisionExpanded && !this.parent.isAllEventsVisible();
        }

        RevisionItem getParent() {
            return this.parent;
        }
    }

    class EventItem
    extends Item<LogEntry.Event> {
        private final RevisionItem parent;
        private final LogEntry.Event event;

        public EventItem(LogEntry.Event event, RevisionItem parent) {
            super(event);
            this.event = event;
            this.parent = parent;
        }

        @Override
        String getItemId() {
            return this.parent.getItemId() + "#" + this.event.getPath() + "#" + this.event.getAction();
        }

        @Override
        boolean isVisible() {
            boolean visible = false;
            if (super.isVisible() && this.parent.isVisible() && this.parent.revisionExpanded) {
                visible = this.parent.isEventVisible(this);
            }
            return visible;
        }

        void actionsToPopup(Point p) {
            Action[] actions = this.event.getUserActions();
            if (actions.length > 0) {
                int idx;
                JPopupMenu menu = new JPopupMenu();
                for (Action a : actions) {
                    menu.add(a);
                }
                for (idx = 0; idx < AbstractSummaryView.this.resultsList.getModel().getSize() && AbstractSummaryView.this.resultsList.getModel().getElementAt(idx) != this; ++idx) {
                }
                if (idx == AbstractSummaryView.this.resultsList.getModel().getSize()) {
                    return;
                }
                Rectangle rect = AbstractSummaryView.this.resultsList.getCellBounds(idx, idx);
                menu.show(AbstractSummaryView.this.resultsList, p.x + rect.x, p.y + rect.y);
            }
        }

        RevisionItem getParent() {
            return this.parent;
        }

        public String toString() {
            return this.event.toString();
        }
    }

    static final class MaxPathWidth {
        public final int visiblePaths;
        public final int maxPathWidth;

        public MaxPathWidth(int visiblePaths, int maxPathWidth) {
            this.visiblePaths = visiblePaths;
            this.maxPathWidth = maxPathWidth;
        }
    }
}

