/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.UpdateTracking;

public class CreateModuleXML
extends Task {
    private final List<FileSet> enabled = new ArrayList<FileSet>(1);
    private final List<FileSet> disabled = new ArrayList<FileSet>(1);
    private final List<FileSet> autoload = new ArrayList<FileSet>(1);
    private final List<FileSet> eager = new ArrayList<FileSet>(1);
    private final List<FileSet> hidden = new ArrayList<FileSet>(1);
    private Integer level;
    private boolean checkBundle = true;
    private File xmldir = null;
    private File trackingdir;
    private boolean failOnMissingManifest = true;
    private List<String> enabledNames = new ArrayList<String>(50);
    private List<String> disabledNames = new ArrayList<String>(10);
    private List<String> autoloadNames = new ArrayList<String>(10);
    private List<String> eagerNames = new ArrayList<String>(10);
    private List<String> hiddenNames = new ArrayList<String>(10);
    private String hiddenList;

    public void addEnabled(FileSet fs) {
        this.enabled.add(fs);
    }

    public void addDisabled(FileSet fs) {
        this.disabled.add(fs);
    }

    public void addAutoload(FileSet fs) {
        this.autoload.add(fs);
    }

    public void addEager(FileSet fs) {
        this.eager.add(fs);
    }

    public void addHidden(FileSet fs) {
        this.hidden.add(fs);
    }

    public void setXmldir(File f) {
        this.xmldir = f;
    }

    public void setUpdateTrackingRoot(File f) {
        this.trackingdir = f;
    }

    public void setFailOnMissingManifest(boolean fail) {
        this.failOnMissingManifest = fail;
    }

    public void setStartLevel(String level) {
        this.level = level.isEmpty() ? null : Integer.valueOf(Integer.parseInt(level));
    }

    public void setStrictCheck(boolean check) {
        this.checkBundle = check;
    }

    public void setHidden(String hiddenList) {
        this.hiddenList = hiddenList;
    }

    public void execute() throws BuildException {
        if (this.xmldir == null) {
            throw new BuildException("Must set xmldir attribute", this.getLocation());
        }
        if (!this.xmldir.exists() && !this.xmldir.mkdirs()) {
            throw new BuildException("Cannot create directory " + this.xmldir, this.getLocation());
        }
        if (this.enabled.isEmpty() && this.disabled.isEmpty() && this.autoload.isEmpty() && this.eager.isEmpty() && this.hidden.isEmpty() && this.hiddenList == null) {
            this.log("Warning: <createmodulexml> with no modules listed", 1);
        }
        for (FileSet fs : this.enabled) {
            this.scanModules(fs, true, false, false, false, this.enabledNames);
        }
        for (FileSet fs : this.disabled) {
            this.scanModules(fs, false, false, false, false, this.disabledNames);
        }
        for (FileSet fs : this.autoload) {
            this.scanModules(fs, false, true, false, false, this.autoloadNames);
        }
        for (FileSet fs : this.eager) {
            this.scanModules(fs, false, false, true, false, this.eagerNames);
        }
        for (FileSet fs : this.hidden) {
            this.scanModules(fs, false, false, false, true, this.hiddenNames);
        }
        if (this.hiddenList != null && this.hiddenList.length() > 0) {
            this.scanModulesInList(this.hiddenList, false, false, false, true, this.hiddenNames);
        }
        Collections.sort(this.enabledNames);
        Collections.sort(this.disabledNames);
        Collections.sort(this.autoloadNames);
        Collections.sort(this.eagerNames);
        Collections.sort(this.hiddenNames);
        if (!this.enabledNames.isEmpty()) {
            this.log("Enabled modules: " + this.enabledNames, 3);
        }
        if (!this.disabledNames.isEmpty()) {
            this.log("Disabled modules: " + this.disabledNames, 3);
        }
        if (!this.autoloadNames.isEmpty()) {
            this.log("Autoload modules: " + this.autoloadNames, 3);
        }
        if (!this.eagerNames.isEmpty()) {
            this.log("Eager modules: " + this.eagerNames, 3);
        }
        if (!this.hiddenNames.isEmpty()) {
            this.log("Hidden modules: " + this.hiddenNames, 3);
        }
    }

    private void scanModules(FileSet fs, boolean isEnabled, boolean isAutoload, boolean isEager, boolean isHidden, List<String> names) throws BuildException {
        DirectoryScanner scan = fs.getDirectoryScanner(this.getProject());
        File dir = scan.getBasedir();
        for (String kid : scan.getIncludedFiles()) {
            File module = new File(dir, kid);
            this.scanOneModule(module, kid, isEnabled, isAutoload, isEager, isHidden, names);
        }
    }

    private void scanModulesInList(String modulesList, boolean isEnabled, boolean isAutoload, boolean isEager, boolean isHidden, List<String> names) throws BuildException {
        String[] modules;
        for (String modulePath : modules = modulesList.split(",")) {
            File module = new File(modulePath);
            this.scanOneModule(module, null, isEnabled, isAutoload, isEager, isHidden, names);
        }
    }

    private void scanOneModule(File module, String kid, boolean isEnabled, boolean isAutoload, boolean isEager, boolean isHidden, List<String> names) throws BuildException {
        UpdateTracking ut = null;
        if (this.trackingdir != null) {
            ut = new UpdateTracking(this.trackingdir.getAbsolutePath());
        }
        this.processModule(module, kid, isEnabled, isAutoload, isEager, isHidden, names, ut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processModule(File module, String kid, boolean isEnabled, boolean isAutoload, boolean isEager, boolean isHidden, List<String> names, UpdateTracking ut) throws BuildException {
        if (!module.exists()) {
            throw new BuildException("Module file does not exist: " + module, this.getLocation());
        }
        if (!module.getName().endsWith(".jar")) {
            throw new BuildException("Only *.jar may be listed, check the fileset: " + module, this.getLocation());
        }
        try {
            block46: {
                try (JarFile jar = new JarFile(module);){
                    String bundle;
                    Manifest m = jar.getManifest();
                    Attributes attr = null;
                    String codename = null;
                    if (m != null) {
                        attr = m.getMainAttributes();
                        codename = JarWithModuleAttributes.extractCodeName(attr);
                    }
                    if (codename == null) {
                        if (this.failOnMissingManifest) {
                            throw new BuildException("Missing manifest tag OpenIDE-Module; " + module + " is not a module", this.getLocation());
                        }
                        this.log("No module manifest in " + module, 1);
                        return;
                    }
                    if (codename.endsWith(" ") || codename.endsWith("\t")) {
                        throw new BuildException("Illegal trailing space in OpenIDE-Module value from " + module, this.getLocation());
                    }
                    int idx = codename.lastIndexOf(47);
                    String codenamebase = idx == -1 ? codename : codename.substring(0, idx);
                    File xml = new File(this.xmldir, codenamebase.replace('.', '-') + ".xml");
                    if (xml.exists()) {
                        this.log("Will not overwrite " + xml + "; skipping...", 3);
                        return;
                    }
                    String displayname = attr.getValue("OpenIDE-Module-Name");
                    if (displayname == null && (bundle = attr.getValue("OpenIDE-Module-Localizing-Bundle")) != null) {
                        InputStream is;
                        ZipEntry entry = jar.getEntry(bundle);
                        if (entry != null) {
                            is = jar.getInputStream(entry);
                        } else {
                            File moduleloc = new File(new File(module.getParentFile(), "locale"), module.getName());
                            if (!moduleloc.isFile()) {
                                throw new BuildException("Expecting localizing bundle: " + bundle + " in: " + module);
                            }
                            try (JarFile jarloc = new JarFile(moduleloc);){
                                ZipEntry entry2 = jarloc.getEntry(bundle);
                                if (entry2 == null) {
                                    throw new BuildException("Expecting localizing bundle: " + bundle + " in: " + module);
                                }
                                is = jarloc.getInputStream(entry2);
                            }
                        }
                        try {
                            Properties p = new Properties();
                            p.load(is);
                            displayname = p.getProperty("OpenIDE-Module-Name");
                        }
                        finally {
                            is.close();
                        }
                    }
                    if (displayname == null) {
                        displayname = codename;
                    }
                    names.add(displayname);
                    String spec = attr.getValue("OpenIDE-Module-Specification-Version");
                    UpdateTracking.Version v = null;
                    if (ut != null) {
                        v = ut.addNewModuleVersion(codename, spec);
                        v.addFileForRoot(module);
                    }
                    if (isHidden) {
                        File h = new File(xml.getParentFile(), xml.getName() + "_hidden");
                        h.createNewFile();
                        break block46;
                    }
                    try (FileOutputStream os = new FileOutputStream(xml);){
                        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        pw.println("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"");
                        pw.println("                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">");
                        pw.println("<module name=\"" + codenamebase + "\">");
                        pw.println("    <param name=\"autoload\">" + isAutoload + "</param>");
                        pw.println("    <param name=\"eager\">" + isEager + "</param>");
                        if (!isAutoload && !isEager) {
                            pw.println("    <param name=\"enabled\">" + isEnabled + "</param>");
                        }
                        pw.println("    <param name=\"jar\">" + kid.replace(File.separatorChar, '/') + "</param>");
                        pw.println("    <param name=\"reloadable\">false</param>");
                        if (this.level != null) {
                            if (attr == null || attr.getValue("Bundle-SymbolicName") == null) {
                                if (this.checkBundle) {
                                    throw new BuildException("startlevel specified, but " + module + " is not OSGi bundle!");
                                }
                            } else {
                                pw.println("    <param name=\"startlevel\">" + this.level + "</param>");
                            }
                        }
                        pw.println("</module>");
                        pw.flush();
                        pw.close();
                    }
                    if (v != null) {
                        v.addFileForRoot(xml);
                    }
                }
            }
            if (ut != null) {
                ut.write();
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Caught while processing " + module + ": " + ioe, (Throwable)ioe, this.getLocation());
        }
    }
}

