/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.responses;

import com.oracle.bmc.devops.model.DeployEnvironment;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateDeployEnvironmentResponse
extends BmcResponse {
    private String location;
    private String etag;
    private String opcWorkRequestId;
    private String opcRequestId;
    private DeployEnvironment deployEnvironment;

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public DeployEnvironment getDeployEnvironment() {
        return this.deployEnvironment;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "location", "etag", "opcWorkRequestId", "opcRequestId", "deployEnvironment"})
    private CreateDeployEnvironmentResponse(int __httpStatusCode__, Map<String, List<String>> headers, String location, String etag, String opcWorkRequestId, String opcRequestId, DeployEnvironment deployEnvironment) {
        super(__httpStatusCode__, headers);
        this.location = location;
        this.etag = etag;
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.deployEnvironment = deployEnvironment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",deployEnvironment=").append(String.valueOf((Object)this.deployEnvironment));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDeployEnvironmentResponse)) {
            return false;
        }
        CreateDeployEnvironmentResponse other = (CreateDeployEnvironmentResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.deployEnvironment, (Object)other.deployEnvironment);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.deployEnvironment == null ? 43 : this.deployEnvironment.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateDeployEnvironmentResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String location;
        private String etag;
        private String opcWorkRequestId;
        private String opcRequestId;
        private DeployEnvironment deployEnvironment;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder deployEnvironment(DeployEnvironment deployEnvironment) {
            this.deployEnvironment = deployEnvironment;
            return this;
        }

        public Builder copy(CreateDeployEnvironmentResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.deployEnvironment(o.getDeployEnvironment());
            return this;
        }

        public CreateDeployEnvironmentResponse build() {
            return new CreateDeployEnvironmentResponse(this.__httpStatusCode__, this.headers, this.location, this.etag, this.opcWorkRequestId, this.opcRequestId, this.deployEnvironment);
        }
    }
}

