/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.action;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategy;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.netbeans.modules.web.beans.CdiUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class SendJMSGenerator {
    private static final Logger LOG = Logger.getLogger(SendJMSGenerator.class.getName());
    private static final String PRODUCES = "Produces";
    private final MessageDestination messageDestination;
    private final Project mdbHolderProject;

    public SendJMSGenerator(MessageDestination messageDestination, Project mdbHolderProject) {
        this.messageDestination = messageDestination;
        this.mdbHolderProject = mdbHolderProject;
    }

    public void genMethods(EnterpriseReferenceContainer container, final String className, String connectionFactoryName, FileObject fileObject, ServiceLocatorStrategy slStrategy, J2eeModuleProvider j2eeModuleProvider) throws IOException {
        FileObject beansFile;
        CdiUtil util;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ContainerClassPathModifier ccpm = (ContainerClassPathModifier)project.getLookup().lookup(ContainerClassPathModifier.class);
        if (ccpm != null) {
            ccpm.extendClasspath(fileObject, new String[]{"j2ee-api"});
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final boolean[] isInjectionTarget = new boolean[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){
            final /* synthetic */ SendJMSGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                isInjectionTarget[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)controller, (TypeElement)typeElement);
            }
        }, true);
        InjectionStrategy injectionStrategy = SendJMSGenerator.getInjectionStrategy(project, isInjectionTarget[0]);
        boolean jakartaPackageNamespace = SendJMSGenerator.isJakartaPackageNamespace(project);
        String destinationFieldName = null;
        String connectionFactoryFieldName = null;
        String factoryName = connectionFactoryName;
        String destinationName = null;
        if (injectionStrategy == InjectionStrategy.INJ_EE7_SOURCES && (util = (CdiUtil)project.getLookup().lookup(CdiUtil.class)) != null && (beansFile = util.enableCdi()) != null) {
            injectionStrategy = InjectionStrategy.INJ_EE7_CDI;
        }
        switch (injectionStrategy.ordinal()) {
            case 3: {
                factoryName = this.generateConnectionFactoryReference(container, factoryName, fileObject, className, jakartaPackageNamespace);
                destinationName = this.generateDestinationReference(container, fileObject, className, jakartaPackageNamespace);
                break;
            }
            case 1: 
            case 2: {
                destinationName = this.messageDestination.getName();
                if (jakartaPackageNamespace) {
                    connectionFactoryFieldName = this.createInjectedResource(fileObject, className, factoryName, "jakarta.jms.ConnectionFactory", jakartaPackageNamespace);
                    destinationFieldName = this.createInjectedResource(fileObject, className, destinationName, this.messageDestination.getType() == MessageDestination.Type.QUEUE ? "jakarta.jms.Queue" : "jakarta.jms.Topic", jakartaPackageNamespace);
                    break;
                }
                connectionFactoryFieldName = this.createInjectedResource(fileObject, className, factoryName, "javax.jms.ConnectionFactory", jakartaPackageNamespace);
                destinationFieldName = this.createInjectedResource(fileObject, className, destinationName, this.messageDestination.getType() == MessageDestination.Type.QUEUE ? "javax.jms.Queue" : "javax.jms.Topic", jakartaPackageNamespace);
                break;
            }
            case 0: {
                if (jakartaPackageNamespace) {
                    destinationName = this.messageDestination.getName();
                    connectionFactoryFieldName = this.createInjectedFactory(fileObject, className, factoryName, "jakarta.jms.JMSContext", jakartaPackageNamespace);
                    destinationFieldName = this.createInjectedResource(fileObject, className, destinationName, this.messageDestination.getType() == MessageDestination.Type.QUEUE ? "jakarta.jms.Queue" : "jakarta.jms.Topic", jakartaPackageNamespace);
                    break;
                }
                destinationName = this.messageDestination.getName();
                connectionFactoryFieldName = this.createInjectedFactory(fileObject, className, factoryName, "javax.jms.JMSContext", jakartaPackageNamespace);
                destinationFieldName = this.createInjectedResource(fileObject, className, destinationName, this.messageDestination.getType() == MessageDestination.Type.QUEUE ? "javax.jms.Queue" : "javax.jms.Topic", jakartaPackageNamespace);
            }
        }
        String sendMethodName = "";
        if (injectionStrategy != InjectionStrategy.INJ_EE7_CDI && injectionStrategy != InjectionStrategy.INJ_EE7_SOURCES) {
            sendMethodName = this.createSendMethod(fileObject, className, this.messageDestination.getName(), jakartaPackageNamespace);
        }
        this.createJMSProducer(fileObject, className, factoryName, connectionFactoryFieldName, destinationName, destinationFieldName, sendMethodName, slStrategy, injectionStrategy, jakartaPackageNamespace);
        if (this.messageDestination != null && injectionStrategy != InjectionStrategy.INJ_EE7_CDI && injectionStrategy != InjectionStrategy.INJ_EE7_SOURCES) {
            try {
                if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
                    j2eeModuleProvider.getConfigSupport().bindMessageDestinationReference(this.messageDestination.getName(), factoryName, this.messageDestination.getName(), this.messageDestination.getType());
                } else if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
                    this.bindMessageDestinationReferenceForEjb(j2eeModuleProvider, fileObject, className, this.messageDestination.getName(), factoryName, this.messageDestination.getName(), this.messageDestination.getType());
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
    }

    private void bindMessageDestinationReferenceForEjb(J2eeModuleProvider j2eeModuleProvider, FileObject fileObject, final String className, String referenceName, String connectionFactoryName, String destName, MessageDestination.Type destType) throws ConfigurationException, IOException {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)fileObject);
        MetadataModel metadataModel = ejbModule.getMetadataModel();
        final String[] ejbName = new String[1];
        final String[] ejbType = new String[1];
        metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){
            final /* synthetic */ SendJMSGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public Void run(EjbJarMetadata metadata) throws Exception {
                Ejb ejb = metadata.findByEjbClass(className);
                if (ejb != null) {
                    ejbName[0] = ejb.getEjbName();
                    if (ejb instanceof Session) {
                        ejbType[0] = "Session";
                    } else if (ejb instanceof MessageDriven) {
                        ejbType[0] = "MessageDriven";
                    } else if (ejb instanceof Entity) {
                        ejbType[0] = "Entity";
                    }
                }
                return null;
            }
        });
        if (ejbName[0] != null && ejbType[0] != null) {
            j2eeModuleProvider.getConfigSupport().bindMessageDestinationReferenceForEjb(ejbName[0], ejbType[0], referenceName, connectionFactoryName, destName, destType);
        }
    }

    private String generateConnectionFactoryReference(EnterpriseReferenceContainer container, String referenceName, FileObject referencingFile, String referencingClass, boolean jakartaPackageNamespace) throws IOException {
        ResourceReference ref = ResourceReference.create((String)referenceName, (String)(jakartaPackageNamespace ? "jakarta.jms.ConnectionFactory" : "javax.jms.ConnectionFactory"), (String)"Container", (String)"Shareable", null);
        return container.addResourceRef(ref, referencingFile, referencingClass);
    }

    private String generateDestinationReference(EnterpriseReferenceContainer container, FileObject referencingFile, String referencingClass, boolean jakartaPackageNamespace) throws IOException {
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.mdbHolderProject);
        String link = projectInformation.getName() + ".jar#" + this.messageDestination.getName();
        Project referenceingProject = FileOwnerQuery.getOwner((FileObject)referencingFile);
        if (this.mdbHolderProject.equals((Object)referenceingProject)) {
            link = link.substring(link.indexOf(35) + 1);
        }
        String queueClass = "jakarta.jms.Queue";
        String topicClass = "jakarta.jms.Topic";
        if (!jakartaPackageNamespace) {
            queueClass = "javax.jms.Queue";
            topicClass = "javax.jms.Topic";
        }
        MessageDestinationReference ref = MessageDestinationReference.create((String)this.messageDestination.getName(), (String)(this.messageDestination.getType() == MessageDestination.Type.QUEUE ? queueClass : topicClass), (String)PRODUCES, (String)link);
        return container.addDestinationRef(ref, referencingFile, referencingClass);
    }

    private String createInjectedResource(FileObject fileObject, String className, String destinationName, String fieldType, boolean jakartaPackageNamespace) throws IOException {
        String fieldName = Utils.makeJavaIdentifierPart(Utils.jndiNameToCamelCase(destinationName, true, "jms"));
        _RetoucheUtil.generateAnnotatedField(fileObject, className, jakartaPackageNamespace ? "jakarta.annotation.Resource" : "javax.annotation.Resource", fieldName, fieldType, Collections.singletonMap("mappedName", destinationName), InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className));
        return fieldName;
    }

    private String createInjectedFactory(FileObject fileObject, String className, String destinationName, String fieldType, final boolean jakartaPackageNamespace) throws IOException {
        String fieldName = "context";
        final ElementHandle<VariableElement> field = _RetoucheUtil.generateAnnotatedField(fileObject, className, jakartaPackageNamespace ? "jakarta.jms.JMSConnectionFactory" : "javax.jms.JMSConnectionFactory", fieldName, fieldType, Collections.singletonMap("", destinationName), InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){
            final /* synthetic */ SendJMSGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy parameter) throws Exception {
                parameter.toPhase(JavaSource.Phase.RESOLVED);
                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)parameter);
                TreePath fieldTree = parameter.getTrees().getPath(field.resolve((CompilationInfo)parameter));
                VariableTree originalTree = (VariableTree)fieldTree.getLeaf();
                ModifiersTree modifiers = originalTree.getModifiers();
                ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(modifiers.getAnnotations());
                annotations.add(0, genUtils.createAnnotation(jakartaPackageNamespace ? "jakarta.inject.Inject" : "javax.inject.Inject"));
                ModifiersTree nueMods = parameter.getTreeMaker().Modifiers(modifiers, annotations);
                parameter.rewrite((Tree)modifiers, (Tree)nueMods);
            }
        }).commit();
        return fieldName;
    }

    private String createSendMethod(FileObject fileObject, final String className, String destination, boolean jakartaPackageNamespace) throws IOException {
        MethodModel.Variable[] parameters = new MethodModel.Variable[]{MethodModel.Variable.create((String)(jakartaPackageNamespace ? "jakarta.jms.Session" : "javax.jms.Session"), (String)"session"), MethodModel.Variable.create((String)Object.class.getName(), (String)"messageData")};
        String methodName = "createJMSMessageFor" + Utils.makeJavaIdentifierPart(Utils.jndiNameToCamelCase(destination, true, null));
        final MethodModel methodModel = MethodModel.create((String)methodName, (String)(jakartaPackageNamespace ? "jakarta.jms.Message" : "javax.jms.Message"), (String)("// TODO create and populate message to send\n" + (jakartaPackageNamespace ? "jakarta" : "javax") + ".jms.TextMessage tm = session.createTextMessage();\ntm.setText(messageData.toString());\nreturn tm;\n"), Arrays.asList(parameters), Collections.singletonList(jakartaPackageNamespace ? "jakarta.jms.JMSException" : "javax.jms.JMSException"), Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){
            final /* synthetic */ SendJMSGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
        return methodName;
    }

    private void createJMSProducer(FileObject fileObject, final String className, String connectionFactoryName, String connectionFactoryFieldName, String destinationName, String destinationFieldName, String sendMethodName, ServiceLocatorStrategy slStrategy, InjectionStrategy injectionStrategy, boolean jakartaPackageNamespace) throws IOException {
        String body;
        String destName = Utils.makeJavaIdentifierPart(destinationName.substring(destinationName.lastIndexOf(47) + 1));
        StringBuffer destBuff = new StringBuffer(destName);
        destBuff.setCharAt(0, Character.toUpperCase(destBuff.charAt(0)));
        ArrayList<String> throwsClause = new ArrayList<String>();
        String parameterType = Object.class.getName();
        switch (injectionStrategy.ordinal()) {
            case 0: {
                body = this.getSendJMSCodeForJMSContext(connectionFactoryFieldName, destinationFieldName);
                parameterType = String.class.getName();
                break;
            }
            case 1: {
                body = this.getSendJMSCodeForCreatedJMSContext(connectionFactoryFieldName, destinationFieldName, jakartaPackageNamespace);
                parameterType = String.class.getName();
                break;
            }
            case 2: {
                throwsClause.add(jakartaPackageNamespace ? "jakarta.jms.JMSException" : "javax.jms.JMSException");
                body = this.getSendJMSCodeWithInjectedFields(connectionFactoryFieldName, destinationFieldName, sendMethodName, jakartaPackageNamespace);
                break;
            }
            default: {
                throwsClause.add(jakartaPackageNamespace ? "jakarta.jms.JMSException" : "javax.jms.JMSException");
                if (slStrategy == null) {
                    body = this.getSendJMSCode(connectionFactoryName, destinationName, sendMethodName, jakartaPackageNamespace);
                    throwsClause.add("javax.naming.NamingException");
                    break;
                }
                body = this.getSendJMSCode(connectionFactoryName, destinationName, sendMethodName, slStrategy, fileObject, className, jakartaPackageNamespace);
            }
        }
        final MethodModel methodModel = MethodModel.create((String)("sendJMSMessageTo" + destBuff), (String)"void", (String)body, Collections.singletonList(MethodModel.Variable.create((String)parameterType, (String)"messageData")), throwsClause, Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){
            final /* synthetic */ SendJMSGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
    }

    private String getSendJMSCodeWithInjectedFields(String connectionFactoryFieldName, String destinationFieldName, String messageMethodName, boolean jakartaPackageNamespace) {
        return MessageFormat.format("{3}.jms.Connection connection = null;\n{3}.jms.Session session = null;\ntry '{' \nconnection = {0}.createConnection();\nsession = connection.createSession(false,{3}.jms.Session.AUTO_ACKNOWLEDGE);\n{3}.jms.MessageProducer messageProducer = session.createProducer({1});\nmessageProducer.send({2}(session, messageData));\n '}' finally '{'\nif (session != null) '{'\ntry '{'\n session.close();\n'}' catch (JMSException e) '{'\njava.util.logging.Logger.getLogger(this.getClass().getName()).log(java.util.logging.Level.WARNING, \"Cannot close session\", e);\n'}'\n'}'\nif (connection != null) '{'\nconnection.close();\n'}'\n'}'\n", connectionFactoryFieldName, destinationFieldName, messageMethodName, jakartaPackageNamespace ? "jakarta" : "javax");
    }

    private String getSendJMSCodeForJMSContext(String contextFieldName, String destinationFieldName) {
        return MessageFormat.format("{0}.createProducer().send({1}, messageData);", contextFieldName, destinationFieldName);
    }

    private String getSendJMSCodeForCreatedJMSContext(String connectionFactoryFieldName, String destinationFieldName, boolean jakartaPackageNamespace) {
        return MessageFormat.format("try ({2}.jms.JMSContext context = {0}.createContext()) '{'\ncontext.createProducer().send({1}, messageData);\n'}'\n", connectionFactoryFieldName, destinationFieldName, jakartaPackageNamespace ? "jakarta" : "javax");
    }

    private String getSendJMSCode(String connectionName, String destinationName, String messageMethodName, ServiceLocatorStrategy sls, FileObject fileObject, String className, boolean jakartaPackageNamespace) {
        String connectionFactory = sls.genJMSFactory(connectionName, fileObject, className);
        String destination = sls.genDestinationLookup(destinationName, fileObject, className);
        return MessageFormat.format("{3}.jms.ConnectionFactory cf = ({3}.jms.ConnectionFactory) " + connectionFactory + ";\n{3}.jms.Connection conn = null;\n{3}.jms.Session s = null;\ntry '{' \nconn = cf.createConnection();\ns = conn.createSession(false,s.AUTO_ACKNOWLEDGE);\n{3}.jms.Destination destination = ({3}.jms.Destination) " + destination + ";\n{3}.jms.MessageProducer mp = s.createProducer(destination);\nmp.send({2}(s,messageData));\n '}' finally '{'\nif (s != null) '{'\ntry '{'\n s.close();\n'}' catch (JMSException e) '{'\njava.util.logging.Logger.getLogger(this.getClass().getName()).log(java.util.logging.Level.WARNING, \"Cannot close session\", e);\n'}'\n'}'\nif (conn != null) '{'\nconn.close();\n'}'\n'}'\n", connectionName, destinationName, messageMethodName, jakartaPackageNamespace ? "jakarta" : "javax");
    }

    private String getSendJMSCode(String connectionName, String destinationName, String messageMethodName, boolean jakartaPackageNamespace) {
        return MessageFormat.format("javax.naming.Context c = new javax.naming.InitialContext();\n{3}.jms.ConnectionFactory cf = ({3}.jms.ConnectionFactory) c.lookup(\"java:comp/env/{0}\");\n{3}.jms.Connection conn = null;\n{3}.jms.Session s = null;\ntry '{' \nconn = cf.createConnection();\ns = conn.createSession(false,s.AUTO_ACKNOWLEDGE);\n{3}.jms.Destination destination = ({3}.jms.Destination) c.lookup(\"java:comp/env/{1}\");\n{3}.jms.MessageProducer mp = s.createProducer(destination);\nmp.send({2}(s,messageData));\n '}' finally '{'\nif (s != null) '{'\ntry '{'\n s.close();\n'}' catch (JMSException e) '{'\njava.util.logging.Logger.getLogger(this.getClass().getName()).log(java.util.logging.Level.WARNING, \"Cannot close session\", e);\n'}'\n'}'\nif (conn != null) '{'\nconn.close();\n'}'\n'}'\n", connectionName, destinationName, messageMethodName, jakartaPackageNamespace ? "jakarta" : "javax");
    }

    public static InjectionStrategy getInjectionStrategy(Project project, boolean injectable) {
        if (!injectable) {
            return InjectionStrategy.NO_INJECT;
        }
        J2eeProjectCapabilities capabilities = J2eeProjectCapabilities.forProject((Project)project);
        if (!capabilities.isEjb32LiteSupported() && !capabilities.isEjb40LiteSupported()) {
            return InjectionStrategy.INJ_COMMON;
        }
        CdiUtil cdiUtil = (CdiUtil)project.getLookup().lookup(CdiUtil.class);
        if (cdiUtil.isCdiEnabled()) {
            return InjectionStrategy.INJ_EE7_CDI;
        }
        return InjectionStrategy.INJ_EE7_SOURCES;
    }

    public static boolean isJakartaPackageNamespace(Project project) {
        J2eeProjectCapabilities capabilities = J2eeProjectCapabilities.forProject((Project)project);
        return capabilities.isEjb40LiteSupported();
    }

    public static enum InjectionStrategy {
        INJ_EE7_CDI,
        INJ_EE7_SOURCES,
        INJ_COMMON,
        NO_INJECT;

    }
}

