/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import java.util.Date;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class UtilDetailsProvider
extends DetailsProvider.Basic {
    private static final String LOGGER_MASK = "java.util.logging.Logger+";
    private static final String LEVEL_MASK = "java.util.logging.Level+";
    private static final String LOCALE_MASK = "java.util.Locale";
    private static final String DATE_MASK = "java.util.Date+";
    private static final String TIMEZONE_MASK = "java.util.TimeZone+";
    private static final String PATTERN_MASK = "java.util.regex.Pattern";
    private static final String CURRENCY_MASK = "java.util.Currency";
    private static final String ZIPENTRY_MASK = "java.util.zip.ZipEntry+";

    public UtilDetailsProvider() {
        super(LOGGER_MASK, LEVEL_MASK, LOCALE_MASK, DATE_MASK, TIMEZONE_MASK, PATTERN_MASK, CURRENCY_MASK, ZIPENTRY_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (LOGGER_MASK.equals(className) || LEVEL_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "name", heap);
        }
        if (LOCALE_MASK.equals(className)) {
            String country;
            String language = DetailsUtils.getInstanceFieldString(instance, "language", heap);
            if (language == null) {
                language = "";
            }
            if ((country = DetailsUtils.getInstanceFieldString(instance, "country", heap)) == null) {
                country = "";
            }
            if (!language.isEmpty() || !country.isEmpty()) {
                if (language.isEmpty() || country.isEmpty()) {
                    return language + country;
                }
                return language + "_" + country;
            }
        } else {
            if (DATE_MASK.equals(className)) {
                long fastTime = DetailsUtils.getLongFieldValue(instance, "fastTime", -1L);
                return new Date(fastTime).toString();
            }
            if (TIMEZONE_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "ID", heap);
            }
            if (PATTERN_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "pattern", heap);
            }
            if (CURRENCY_MASK.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "currencyCode", heap);
            }
            if (ZIPENTRY_MASK.equals(className)) {
                String name = DetailsUtils.getInstanceFieldString(instance, "name", heap);
                long size = DetailsUtils.getLongFieldValue(instance, "size", -1L);
                if (name != null && size != -1L) {
                    return String.format("%s, size=%d", name, size);
                }
                return name;
            }
        }
        return null;
    }
}

