/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import org.netbeans.modules.tasklist.todo.settings.CommentTags;

public abstract class FileIdentifier
implements Comparable<FileIdentifier> {
    private CommentTags commentTags;

    public FileIdentifier(CommentTags commentTags) {
        this.commentTags = commentTags == null ? new CommentTags() : commentTags;
    }

    public CommentTags getCommentTags() {
        return this.commentTags;
    }

    public void setCommentTags(CommentTags commentTags) {
        this.commentTags = commentTags;
    }

    public boolean isValid() {
        boolean lineCommentValid = !this.commentTags.getLineComment().isEmpty() || !this.commentTags.isLineCommentEnabled();
        boolean blockCommentValid = !this.commentTags.getBlockCommentStart().isEmpty() && !this.commentTags.getBlockCommentEnd().isEmpty() || !this.commentTags.isBlockCommentEnabled();
        return lineCommentValid && blockCommentValid && (this.commentTags.isLineCommentEnabled() || this.commentTags.isBlockCommentEnabled());
    }

    public abstract String getDisplayName();

    public abstract String getId();

    abstract Type getType();

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public int compareTo(FileIdentifier other) {
        int comparePriority = this.getType().getSortPriority().compareTo(other.getType().getSortPriority());
        if (comparePriority != 0) {
            return comparePriority;
        }
        return this.getDisplayName().compareToIgnoreCase(other.getDisplayName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileIdentifier)) {
            return false;
        }
        FileIdentifier other = (FileIdentifier)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getId().equalsIgnoreCase(other.getId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.commentTags != null ? this.commentTags.hashCode() : 0);
        return hash;
    }

    static enum Type {
        MIME(1, "MIME Types"),
        EXTENSION(2, "Extensions");

        private final Integer sortPriority;
        private final String displayName;

        private Type(Integer sortPriority, String displayName) {
            this.displayName = displayName;
            this.sortPriority = sortPriority;
        }

        public Integer getSortPriority() {
            return this.sortPriority;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

