/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.maven.spi.customizer.SelectedItemsTablePersister;

public final class SelectedItemsTable
extends JTable {
    private static final int CHECKBOX_WIDTH = new JCheckBox().getWidth();

    public SelectedItemsTable(SelectedItemsTableModel model) {
        super(model);
        this.getColumnModel().getColumn(0).setMaxWidth(CHECKBOX_WIDTH + 20);
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 2 * this.getRowMargin());
        this.setTableHeader(null);
        this.getSelectionModel().setSelectionMode(0);
        this.setShowGrid(false);
        final AbstractAction switchAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = SelectedItemsTable.this.getSelectedRow();
                if (row == -1) {
                    return;
                }
                Boolean b = (Boolean)SelectedItemsTable.this.getValueAt(row, 0);
                SelectedItemsTable.this.setValueAt(b == false, row, 0);
            }
        };
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SelectedItemsTable this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                switchAction.actionPerformed(null);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        this.getActionMap().put("startEditing", switchAction);
    }

    public SelectedItemsTable() {
        this(null);
    }

    public static final class SelectedItemsTableModel
    extends AbstractTableModel {
        private Boolean[] selected;
        private Boolean[] originalSelected;
        private String[] pkgNames;
        private final SelectedItemsTablePersister persister;

        public SelectedItemsTableModel(SelectedItemsTablePersister persister) {
            this.persister = persister;
            this.reloadData(persister.read());
        }

        void reloadData(SortedMap<String, Boolean> items) {
            this.selected = new Boolean[items.size()];
            items.values().toArray(this.selected);
            if (this.originalSelected == null) {
                this.originalSelected = new Boolean[items.size()];
                System.arraycopy(this.selected, 0, this.originalSelected, 0, this.selected.length);
            }
            this.pkgNames = new String[items.size()];
            items.keySet().toArray(this.pkgNames);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.pkgNames.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.selected[rowIndex];
            }
            return this.pkgNames[rowIndex];
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0) : "Who is trying to modify second column?";
            this.selected[rowIndex] = (Boolean)aValue;
            this.persister.write(this.getItemsMap());
            this.fireTableCellUpdated(rowIndex, 0);
        }

        private SortedMap<String, Boolean> getItemsMap() {
            TreeMap<String, Boolean> itemsMap = new TreeMap<String, Boolean>();
            for (int i = 0; i < this.pkgNames.length; ++i) {
                itemsMap.put(this.pkgNames[i], this.selected[i]);
            }
            return itemsMap;
        }

        public boolean isChanged() {
            return !Arrays.asList(this.selected).equals(Arrays.asList(this.originalSelected));
        }
    }
}

