/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.chrome_devtools_protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.chrome_devtools_protocol.DebuggerDomain;
import org.netbeans.lib.chrome_devtools_protocol.DebuggerException;
import org.netbeans.lib.chrome_devtools_protocol.ErrorData;
import org.netbeans.lib.chrome_devtools_protocol.MethodCall;
import org.netbeans.lib.chrome_devtools_protocol.RuntimeDomain;
import org.netbeans.lib.chrome_devtools_protocol.json.Endpoint;

public class ChromeDevToolsClient
implements Closeable {
    private static final Logger LOG = Logger.getLogger(ChromeDevToolsClient.class.getName());
    private static final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
    private static final Gson gson = new Gson();
    private final AtomicInteger idSupplier = new AtomicInteger();
    private final DebuggerDomain debuggerDomain;
    private final RuntimeDomain runtimeDomain;
    private final ConcurrentHashMap<Integer, CompletableFuture<JsonElement>> callbacks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<Consumer<JsonElement>>> eventHandler = new ConcurrentHashMap();
    private final URI websocketUri;
    private WebSocket webSocket;

    public static Endpoint[] listEndpoints(String hostname, int port) throws IOException {
        try {
            URI jsonUri = new URI("http", null, hostname, port, "/json", null, null);
            HttpResponse<String> result = client.send(HttpRequest.newBuilder(jsonUri).GET().build(), HttpResponse.BodyHandlers.ofString());
            if (result.statusCode() == 404) {
                jsonUri = new URI("http", null, hostname, port, "/json/list", null, null);
                result = client.send(HttpRequest.newBuilder(jsonUri).GET().build(), HttpResponse.BodyHandlers.ofString());
            }
            if (result.statusCode() != 200) {
                throw new IOException("Failed to fetch endpoint list (http-status: " + result.statusCode() + ")" + result.body());
            }
            return (Endpoint[])gson.fromJson(result.body(), Endpoint[].class);
        }
        catch (InterruptedException | URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public ChromeDevToolsClient(URI websocketUri) {
        this.websocketUri = websocketUri;
        this.debuggerDomain = new DebuggerDomain(this);
        this.runtimeDomain = new RuntimeDomain(this);
    }

    public void connect() {
        if (this.webSocket != null) {
            try {
                this.close();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to close previous connection", ex);
            }
        }
        try {
            this.webSocket = client.newWebSocketBuilder().buildAsync(this.websocketUri, new WebSocket.Listener(){
                StringBuilder sb = new StringBuilder();

                @Override
                public void onOpen(WebSocket webSocket) {
                    webSocket.request(1L);
                }

                @Override
                public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                    return null;
                }

                @Override
                public void onError(WebSocket webSocket, Throwable error) {
                    ChromeDevToolsClient.this.callbacks.values().stream().forEach(c -> c.completeExceptionally(error));
                }

                @Override
                public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                    this.sb.append(data);
                    if (last) {
                        String result = this.sb.toString();
                        LOG.log(Level.FINE, "Received: {0}", result);
                        this.dispatchMethod(result);
                        this.sb.setLength(0);
                    }
                    webSocket.request(1L);
                    return null;
                }

                private void dispatchMethod(String data) {
                    JsonElement jsonElement = (JsonElement)gson.fromJson(data, JsonElement.class);
                    if (jsonElement.isJsonObject() && jsonElement.getAsJsonObject().has("id")) {
                        int id = jsonElement.getAsJsonObject().getAsJsonPrimitive("id").getAsInt();
                        CompletableFuture<JsonElement> callback = ChromeDevToolsClient.this.callbacks.remove(id);
                        if (callback != null) {
                            if (jsonElement.getAsJsonObject().has("error")) {
                                try {
                                    ErrorData ed = (ErrorData)gson.fromJson(jsonElement.getAsJsonObject().get("error"), ErrorData.class);
                                    callback.completeExceptionally(new DebuggerException(ed.getCode(), ed.getMessage(), ed.getData()));
                                }
                                catch (Exception ex) {
                                    throw new DebuggerException(jsonElement.getAsJsonObject().get("error").toString());
                                }
                            } else {
                                callback.complete(jsonElement.getAsJsonObject().get("result"));
                            }
                        }
                    } else if (jsonElement.isJsonObject() && jsonElement.getAsJsonObject().has("method")) {
                        List handlers = ChromeDevToolsClient.this.eventHandler.getOrDefault(jsonElement.getAsJsonObject().getAsJsonPrimitive("method").getAsString(), Collections.emptyList());
                        for (Consumer handler : handlers) {
                            handler.accept(jsonElement.getAsJsonObject().get("params"));
                        }
                    }
                }
            }).get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.webSocket != null) {
                this.webSocket.sendClose(1000, "").get();
                this.webSocket = null;
            }
            for (CompletableFuture<JsonElement> cf : this.callbacks.values()) {
                cf.completeExceptionally(new DebuggerException("Connection closed"));
            }
            this.callbacks.clear();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    public boolean connected() {
        return this.webSocket != null;
    }

    public RuntimeDomain getRuntime() {
        return this.runtimeDomain;
    }

    public DebuggerDomain getDebugger() {
        return this.debuggerDomain;
    }

    Gson getGson() {
        return gson;
    }

    int getId() {
        return this.idSupplier.getAndIncrement();
    }

    CompletionStage<JsonElement> methodCall(String method, Object parameters) {
        int id = this.getId();
        MethodCall methodCall = new MethodCall();
        methodCall.setId(id);
        methodCall.setMethod(method);
        if (parameters != null) {
            methodCall.setParams(parameters);
        }
        CompletableFuture<JsonElement> resultProvider = new CompletableFuture<JsonElement>();
        this.callbacks.put(id, resultProvider);
        String jsonPayload = gson.toJson((Object)methodCall);
        LOG.log(Level.FINE, "methodCall: {0}", jsonPayload);
        this.webSocket.sendText(jsonPayload, true).whenComplete((ws, ex) -> {
            if (ex != null) {
                resultProvider.completeExceptionally((Throwable)ex);
                this.callbacks.remove(id);
            }
        });
        return resultProvider;
    }

    void registerEventHandler(String event, Consumer<JsonElement> handler) {
        this.eventHandler.computeIfAbsent(event, s -> new CopyOnWriteArrayList()).add(handler);
    }

    void unregisterEventHandler(String event, Consumer<JsonElement> handler) {
        this.eventHandler.computeIfAbsent(event, s -> new CopyOnWriteArrayList()).remove(handler);
    }
}

