/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.AttachInstancePoolInstanceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class AttachInstancePoolInstanceRequest
extends BmcRequest<AttachInstancePoolInstanceDetails> {
    private String instancePoolId;
    private AttachInstancePoolInstanceDetails attachInstancePoolInstanceDetails;
    private String opcRetryToken;

    public String getInstancePoolId() {
        return this.instancePoolId;
    }

    public AttachInstancePoolInstanceDetails getAttachInstancePoolInstanceDetails() {
        return this.attachInstancePoolInstanceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public AttachInstancePoolInstanceDetails getBody$() {
        return this.attachInstancePoolInstanceDetails;
    }

    public Builder toBuilder() {
        return new Builder().instancePoolId(this.instancePoolId).attachInstancePoolInstanceDetails(this.attachInstancePoolInstanceDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instancePoolId=").append(String.valueOf(this.instancePoolId));
        sb.append(",attachInstancePoolInstanceDetails=").append(String.valueOf((Object)this.attachInstancePoolInstanceDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttachInstancePoolInstanceRequest)) {
            return false;
        }
        AttachInstancePoolInstanceRequest other = (AttachInstancePoolInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instancePoolId, other.instancePoolId) && Objects.equals((Object)this.attachInstancePoolInstanceDetails, (Object)other.attachInstancePoolInstanceDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instancePoolId == null ? 43 : this.instancePoolId.hashCode());
        result = result * 59 + (this.attachInstancePoolInstanceDetails == null ? 43 : this.attachInstancePoolInstanceDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AttachInstancePoolInstanceRequest, AttachInstancePoolInstanceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instancePoolId = null;
        private AttachInstancePoolInstanceDetails attachInstancePoolInstanceDetails = null;
        private String opcRetryToken = null;

        public Builder instancePoolId(String instancePoolId) {
            this.instancePoolId = instancePoolId;
            return this;
        }

        public Builder attachInstancePoolInstanceDetails(AttachInstancePoolInstanceDetails attachInstancePoolInstanceDetails) {
            this.attachInstancePoolInstanceDetails = attachInstancePoolInstanceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachInstancePoolInstanceRequest o) {
            this.instancePoolId(o.getInstancePoolId());
            this.attachInstancePoolInstanceDetails(o.getAttachInstancePoolInstanceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachInstancePoolInstanceRequest build() {
            AttachInstancePoolInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AttachInstancePoolInstanceDetails body) {
            this.attachInstancePoolInstanceDetails(body);
            return this;
        }

        public AttachInstancePoolInstanceRequest buildWithoutInvocationCallback() {
            AttachInstancePoolInstanceRequest request = new AttachInstancePoolInstanceRequest();
            request.instancePoolId = this.instancePoolId;
            request.attachInstancePoolInstanceDetails = this.attachInstancePoolInstanceDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

