/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.UpdateIPSecConnectionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateIPSecConnectionRequest
extends BmcRequest<UpdateIPSecConnectionDetails> {
    private String ipscId;
    private UpdateIPSecConnectionDetails updateIPSecConnectionDetails;
    private String ifMatch;

    public String getIpscId() {
        return this.ipscId;
    }

    public UpdateIPSecConnectionDetails getUpdateIPSecConnectionDetails() {
        return this.updateIPSecConnectionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateIPSecConnectionDetails getBody$() {
        return this.updateIPSecConnectionDetails;
    }

    public Builder toBuilder() {
        return new Builder().ipscId(this.ipscId).updateIPSecConnectionDetails(this.updateIPSecConnectionDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ipscId=").append(String.valueOf(this.ipscId));
        sb.append(",updateIPSecConnectionDetails=").append(String.valueOf((Object)this.updateIPSecConnectionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateIPSecConnectionRequest)) {
            return false;
        }
        UpdateIPSecConnectionRequest other = (UpdateIPSecConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ipscId, other.ipscId) && Objects.equals((Object)this.updateIPSecConnectionDetails, (Object)other.updateIPSecConnectionDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ipscId == null ? 43 : this.ipscId.hashCode());
        result = result * 59 + (this.updateIPSecConnectionDetails == null ? 43 : this.updateIPSecConnectionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateIPSecConnectionRequest, UpdateIPSecConnectionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ipscId = null;
        private UpdateIPSecConnectionDetails updateIPSecConnectionDetails = null;
        private String ifMatch = null;

        public Builder ipscId(String ipscId) {
            this.ipscId = ipscId;
            return this;
        }

        public Builder updateIPSecConnectionDetails(UpdateIPSecConnectionDetails updateIPSecConnectionDetails) {
            this.updateIPSecConnectionDetails = updateIPSecConnectionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateIPSecConnectionRequest o) {
            this.ipscId(o.getIpscId());
            this.updateIPSecConnectionDetails(o.getUpdateIPSecConnectionDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateIPSecConnectionRequest build() {
            UpdateIPSecConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateIPSecConnectionDetails body) {
            this.updateIPSecConnectionDetails(body);
            return this;
        }

        public UpdateIPSecConnectionRequest buildWithoutInvocationCallback() {
            UpdateIPSecConnectionRequest request = new UpdateIPSecConnectionRequest();
            request.ipscId = this.ipscId;
            request.updateIPSecConnectionDetails = this.updateIPSecConnectionDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

