/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.tls;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.netbeans.modules.docker.tls.Asn1Object;

public class DerParser {
    private final InputStream is;

    public DerParser(InputStream is) {
        this.is = is;
    }

    public Asn1Object read() throws IOException {
        int tag = this.is.read();
        if (tag < 0) {
            throw new IOException("No more data to read");
        }
        int length = this.readLength();
        return new Asn1Object(tag, this.readValue(length));
    }

    private int readLength() throws IOException {
        int read = this.is.read();
        if (read < 0) {
            throw new IOException("No more data to read");
        }
        if ((read & 0xFFFFFF80) == 0) {
            return read;
        }
        int num = read & 0x7F;
        if (read >= 255 || num > 4) {
            throw new IOException("Length too big to be used");
        }
        return new BigInteger(1, this.readValue(num)).intValue();
    }

    private byte[] readValue(int length) throws IOException {
        int real;
        byte[] value = new byte[length];
        for (int count = 0; count < length; count += real) {
            real = this.is.read(value, count, length - count);
            if (real >= 0) continue;
            throw new IOException("Can't read the requested value");
        }
        return value;
    }
}

