/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.sourcemap;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.web.common.sourcemap.Mapping;
import org.netbeans.modules.web.common.sourcemap.MappingTokenizer;

public class SourceMap {
    private static final String SUPPORTED_VERSION = "3";
    private static final String INVALIDATING_STRING = ")]}";
    private static final Map<String, SourceMap> cache = new WeakHashMap<String, SourceMap>();
    private JSONObject sourceMap;
    private final Map<Integer, List<Mapping>> mappings = new HashMap<Integer, List<Mapping>>();
    private final Map<String, Map<Integer, List<Mapping>>> inverseMappings = new HashMap<String, Map<Integer, List<Mapping>>>();
    private final String sourceRoot;

    public static SourceMap parse(String sourceMap) throws IllegalArgumentException {
        SourceMap map = cache.get(sourceMap);
        if (map == null) {
            map = new SourceMap(sourceMap);
            cache.put(sourceMap, map);
        }
        return map;
    }

    private static String removeInvalidatingString(String sourceMap) {
        int firstLineEnd;
        if (sourceMap.startsWith(INVALIDATING_STRING) && (firstLineEnd = sourceMap.indexOf(10)) > 0) {
            return sourceMap.substring(firstLineEnd + 1);
        }
        return sourceMap;
    }

    private SourceMap(String sourceMap) {
        this(SourceMap.toJSONObject(SourceMap.removeInvalidatingString(sourceMap)));
    }

    private SourceMap(JSONObject sourceMap) {
        String version;
        this.sourceMap = sourceMap;
        Object versionValue = sourceMap.get((Object)"version");
        String string = version = versionValue == null ? null : versionValue.toString();
        if (!SUPPORTED_VERSION.equals(version)) {
            throw new IllegalArgumentException("Unsupported version of the source map: " + version);
        }
        String mappingInfo = (String)sourceMap.get((Object)"mappings");
        MappingTokenizer tokenizer = new MappingTokenizer(mappingInfo);
        int line = 0;
        ArrayList<Mapping> lineInfo = null;
        for (Mapping mapping : tokenizer) {
            if (mapping == Mapping.NEW_LINE) {
                if (lineInfo != null) {
                    this.mappings.put(line, lineInfo);
                    lineInfo = null;
                }
                ++line;
                continue;
            }
            if (lineInfo == null) {
                lineInfo = new ArrayList<Mapping>();
            } else {
                Mapping lastMapping = (Mapping)lineInfo.get(lineInfo.size() - 1);
                if (lastMapping.getColumn() == mapping.getColumn()) continue;
            }
            lineInfo.add(mapping);
            this.registerInverseMapping(line, mapping);
        }
        if (lineInfo != null) {
            this.mappings.put(line, lineInfo);
        }
        this.sourceRoot = (String)sourceMap.get((Object)"sourceRoot");
    }

    private void registerInverseMapping(int line, Mapping mapping) {
        int index;
        String sourcePath = this.getSourcePath(mapping.getSourceIndex());
        Map<Integer, List<Mapping>> imm = this.inverseMappings.get(sourcePath);
        if (imm == null) {
            imm = new HashMap<Integer, List<Mapping>>();
            this.inverseMappings.put(sourcePath, imm);
        }
        int origLine = mapping.getOriginalLine();
        int origColumn = mapping.getOriginalColumn();
        List<Mapping> ims = imm.get(origLine);
        if (ims == null) {
            ims = new ArrayList<Mapping>(6);
            imm.put(origLine, ims);
        }
        if ((index = SourceMap.binarySearch(ims, origColumn)) >= 0) {
            return;
        }
        index = -index - 1;
        Mapping im = new Mapping();
        im.setOriginalLine(line);
        im.setColumn(origColumn);
        im.setOriginalColumn(mapping.getColumn());
        ims.add(index, im);
    }

    public String getFile() {
        return (String)this.sourceMap.get((Object)"file");
    }

    public List<String> getSources() {
        JSONArray sources = (JSONArray)this.sourceMap.get((Object)"sources");
        return Collections.unmodifiableList(sources);
    }

    public String getSourcePath(int sourceIndex) {
        JSONArray sources = (JSONArray)this.sourceMap.get((Object)"sources");
        String source = (String)sources.get(sourceIndex);
        if (this.sourceRoot != null && !this.sourceRoot.isEmpty()) {
            return this.sourceRoot + File.separator + source;
        }
        return source;
    }

    public String getName(int nameIndex) {
        JSONArray names = (JSONArray)this.sourceMap.get((Object)"names");
        return (String)names.get(nameIndex);
    }

    public Mapping findMapping(int line, int column) {
        Mapping result = null;
        List<Mapping> lineInfo = this.mappings.get(line);
        if (lineInfo != null) {
            int index = SourceMap.binarySearch(lineInfo, column);
            if (index < 0 && (index = -index - 2) < 0) {
                index = 0;
            }
            return lineInfo.get(index);
        }
        return result;
    }

    public Mapping findMapping(int line) {
        Mapping result = null;
        List<Mapping> lineInfo = this.mappings.get(line);
        if (lineInfo != null && !lineInfo.isEmpty()) {
            result = lineInfo.get(0);
        }
        return result;
    }

    List<Mapping> findAllMappings(int line) {
        return this.mappings.get(line);
    }

    public Mapping findInverseMapping(String sourcePath, int originalLine, int originalColumn) {
        List<Mapping> lineInfo;
        Mapping result = null;
        Map<Integer, List<Mapping>> imm = this.inverseMappings.get(sourcePath);
        if (imm != null && (lineInfo = imm.get(originalLine)) != null) {
            int index = SourceMap.binarySearch(lineInfo, originalColumn);
            if (index < 0 && (index = -index - 2) < 0) {
                index = 0;
            }
            return lineInfo.get(index);
        }
        return result;
    }

    public Mapping findInverseMapping(String sourcePath, int originalLine) {
        List<Mapping> lineInfo;
        Mapping result = null;
        Map<Integer, List<Mapping>> imm = this.inverseMappings.get(sourcePath);
        if (imm != null && (lineInfo = imm.get(originalLine)) != null && !lineInfo.isEmpty()) {
            result = lineInfo.get(0);
        }
        return result;
    }

    List<Mapping> findAllInverseMappings(String sourcePath, int line) {
        Map<Integer, List<Mapping>> imm = this.inverseMappings.get(sourcePath);
        if (imm != null) {
            return imm.get(line);
        }
        return null;
    }

    private static JSONObject toJSONObject(String text) throws IllegalArgumentException {
        try {
            JSONObject json = (JSONObject)JSONValue.parseWithException((String)text);
            return json;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(text);
        }
    }

    private static int binarySearch(List<Mapping> mappings, int column) {
        int i1 = 0;
        int i2 = mappings.size() - 1;
        while (i1 <= i2) {
            int i = i1 + i2 >>> 1;
            Mapping middle = mappings.get(i);
            int mc = middle.getColumn();
            if (mc == column) {
                return i;
            }
            if (mc < column) {
                i1 = i + 1;
                continue;
            }
            if (mc > column) {
                i2 = i - 1;
                continue;
            }
            return i;
        }
        return -i1 - 1;
    }

    private static boolean sortedAdd(Mapping m, List<Mapping> mappings, Comparator<Mapping> cmp) {
        int pos = SourceMap.binarySearch(mappings, m.getColumn());
        if (pos >= 0) {
            return false;
        }
        mappings.add(-pos, m);
        return true;
    }
}

