/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class FieldEncapsulation {
    private static final Logger LOG = Logger.getLogger(FieldEncapsulation.class.getName());
    private static final String KW_THIS = "this";
    static final boolean ALLOW_ENUMS_DEFAULT = false;
    static final String ALLOW_ENUMS_KEY = "allow.enums";

    public static ErrorDescription protectedField(HintContext ctx) {
        return FieldEncapsulation.create(ctx, Utilities.Visibility.PROTECTED, NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_ProtectedField"));
    }

    public static ErrorDescription publicField(HintContext ctx) {
        return FieldEncapsulation.create(ctx, Utilities.Visibility.PUBLIC, NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_PublicField"));
    }

    public static ErrorDescription packageField(HintContext ctx) {
        return FieldEncapsulation.create(ctx, Utilities.Visibility.PACKAGE_PRIVATE, NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_PackageField"));
    }

    public static ErrorDescription privateField(HintContext ctx) {
        assert (ctx != null);
        TreePath tp = ctx.getPath();
        Element selectElement = ctx.getInfo().getTrees().getElement(tp);
        if (selectElement == null || selectElement.getKind() != ElementKind.FIELD || !((VariableElement)selectElement).getModifiers().contains((Object)Modifier.PRIVATE) || ((VariableElement)selectElement).getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        ExpressionTree subSelect = ((MemberSelectTree)tp.getLeaf()).getExpression();
        if (subSelect.getKind() == Tree.Kind.IDENTIFIER && KW_THIS.contentEquals(((IdentifierTree)subSelect).getName()) || subSelect.getKind() == Tree.Kind.MEMBER_SELECT && KW_THIS.contentEquals(((MemberSelectTree)subSelect).getIdentifier())) {
            return null;
        }
        TypeElement selectOwner = FieldEncapsulation.getEnclosingClass(tp, ctx.getInfo().getTrees());
        if (selectOwner == null || SourceUtils.getOutermostEnclosingTypeElement((Element)selectElement) != SourceUtils.getOutermostEnclosingTypeElement((Element)selectOwner)) {
            return null;
        }
        SourceUtils.getOutermostEnclosingTypeElement((Element)selectElement);
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)tp, (String)NbBundle.getMessage(FieldEncapsulation.class, (String)"TXT_OtherPrivateField"), (Fix[])new Fix[0]);
    }

    private static TypeElement getEnclosingClass(TreePath path, Trees trees) {
        while (path != null && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind())) {
                return (TypeElement)trees.getElement(path);
            }
            path = path.getParentPath();
        }
        return null;
    }

    private static ErrorDescription create(HintContext ctx, Utilities.Visibility visibility, String message) {
        Element type;
        assert (ctx != null);
        assert (message != null);
        TreePath tp = ctx.getPath();
        Tree parent = tp.getParentPath().getLeaf();
        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) || ctx.getInfo().getTreeUtilities().isInterface((ClassTree)parent)) {
            return null;
        }
        VariableTree vt = (VariableTree)tp.getLeaf();
        ModifiersTree mt = vt.getModifiers();
        if (mt.getFlags().contains((Object)Modifier.FINAL) || Utilities.effectiveVisibility(tp) != visibility) {
            return null;
        }
        if (ctx.getPreferences().getBoolean(ALLOW_ENUMS_KEY, false) && (type = ctx.getInfo().getTrees().getElement(new TreePath(tp, vt.getType()))) != null && type.getKind() == ElementKind.ENUM) {
            return null;
        }
        Collection<? extends TreePath> fieldGroup = Utilities.resolveFieldGroup(ctx.getInfo(), tp);
        if (fieldGroup.size() != 1 && fieldGroup.iterator().next().getLeaf() != tp.getLeaf()) {
            return null;
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)tp, (String)message, (Fix[])new Fix[]{new FixImpl(TreePathHandle.create((TreePath)tp, (CompilationInfo)ctx.getInfo()))});
    }

    private static boolean hasRequiredVisibility(Set<Modifier> mods, Modifier reqMod) {
        return reqMod != null ? mods.contains((Object)reqMod) : (mods.isEmpty() ? true : !EnumSet.copyOf(mods).removeAll(EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC)));
    }

    private static class FixImpl
    implements Fix {
        private final TreePathHandle handle;

        public FixImpl(TreePathHandle handle) {
            this.handle = handle;
        }

        public String getText() {
            return NbBundle.getMessage(FieldEncapsulation.class, (String)"FIX_EncapsulateField");
        }

        public ChangeInfo implement() throws Exception {
            FileObject file = this.handle.getFileObject();
            JTextComponent comp = EditorRegistry.lastFocusedComponent();
            if (file != null && file == FixImpl.getFileObject(comp)) {
                final int[] pos = new int[]{-1};
                JavaSource.forFileObject((FileObject)file).runUserActionTask((Task)new Task<CompilationController>(){
                    final /* synthetic */ FixImpl this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(CompilationController info) throws Exception {
                        info.toPhase(JavaSource.Phase.PARSED);
                        TreePath tp = this.this$0.handle.resolve((CompilationInfo)info);
                        if (tp != null && tp.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                            pos[0] = (int)info.getTrees().getSourcePositions().getEndPosition(tp.getCompilationUnit(), ((VariableTree)tp.getLeaf()).getType()) + 1;
                        }
                    }
                }, true);
                this.invokeRefactoring(comp, pos[0]);
            }
            return null;
        }

        public static FileObject getFileObject(JTextComponent comp) {
            if (comp == null) {
                return null;
            }
            Document doc = comp.getDocument();
            if (doc == null) {
                return null;
            }
            Object sdp = doc.getProperty("stream");
            if (sdp instanceof FileObject) {
                return (FileObject)sdp;
            }
            if (sdp instanceof DataObject) {
                return ((DataObject)sdp).getPrimaryFile();
            }
            return null;
        }

        private void invokeRefactoring(final JTextComponent component, final int position) {
            final Action a = Actions.forID((String)"Refactoring", (String)"org.netbeans.modules.refactoring.java.api.ui.EncapsulateFieldAction");
            if (a == null) {
                LOG.warning("Encapsulate Field action not found");
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ FixImpl this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (position != -1) {
                        component.setCaretPosition(position);
                    }
                    a.actionPerformed(new ActionEvent(component, 0, null));
                }
            });
        }
    }
}

