/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.suggestions.IfToSwitchSupport;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ConvertToStringSwitch {
    static final boolean DEF_ALSO_EQ = true;
    static final int DEF_THRESHOLD = 3;
    static final String KEY_ALSO_EQ = "also-equals";
    static final String KEY_THRESHOLD = "threshold";
    public static final boolean DEFAULT_OPTION_GENERATE_EMPTY_DEFAULT = true;
    public static final String OPTION_GENERATE_EMPTY_DEFAULT = "iftoswitch.generate.default";
    private static final String[] INIT_PATTERNS = new String[]{"$c1.equals($c2)", "$c1.contentEquals($c2)", "$c1 == $c2"};
    private static final String[] PATTERNS = new String[]{"$var.equals($constant)", "$constant.equals($var)", "$var.contentEquals($constant)", "$constant.contentEquals($var)", "$var == $constant", "$constant == $var"};

    public static List<ErrorDescription> hint(final HintContext ctx) {
        if (ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.IF) {
            return null;
        }
        final TypeElement jlString = ctx.getInfo().getElements().getTypeElement("java.lang.String");
        if (jlString == null) {
            return null;
        }
        final ArrayList<String> initPatterns = new ArrayList<String>(INIT_PATTERNS.length);
        final boolean acceptEqEq = ctx.getPreferences().getBoolean(KEY_ALSO_EQ, true);
        initPatterns.addAll(Arrays.asList(INIT_PATTERNS));
        IfToSwitchSupport eval = new IfToSwitchSupport(ctx){
            private boolean[] varConst;
            {
                super(ctx2);
                this.varConst = new boolean[1];
            }

            @Override
            protected Object evalConstant(TreePath path) {
                Object o;
                TypeMirror m = this.ci.getTrees().getTypeMirror(path);
                if ((m.getKind() == TypeKind.NULL || this.ci.getTypes().asElement(m) == jlString) && (ArithmeticUtilities.isNull(o = ArithmeticUtilities.compute(this.ci, path, true, true)) || ArithmeticUtilities.isRealValue(o))) {
                    return o;
                }
                return null;
            }

            @Override
            protected TreePath matchesChainedItem(TreePath test, TreePath variable) {
                this.varConst[0] = false;
                TreePath p = ConvertToStringSwitch.isStringComparison(ctx, test, this.varConst, variable);
                if (p == null) {
                    return null;
                }
                if (this.varConst[0]) {
                    this.controlVariableNotNull();
                }
                return p;
            }

            @Override
            protected TreePath matches(TreePath test, boolean initial) {
                int cnt = -1;
                for (String pat : initPatterns) {
                    ++cnt;
                    if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)test, (String)pat, (boolean)true)) continue;
                    TreePath c1 = (TreePath)ctx.getVariables().get("$c1");
                    TypeMirror m = ctx.getInfo().getTrees().getTypeMirror(c1);
                    boolean n = false;
                    if (!Utilities.isValidType(m) || m.getKind() != TypeKind.NULL && ctx.getInfo().getTypes().asElement(m) != jlString) continue;
                    n |= m.getKind() == TypeKind.NULL;
                    TreePath c2 = (TreePath)ctx.getVariables().get("$c2");
                    m = ctx.getInfo().getTrees().getTypeMirror(c2);
                    if (!Utilities.isValidType(m) || m.getKind() != TypeKind.NULL && ctx.getInfo().getTypes().asElement(m) != jlString || cnt == 2 && !acceptEqEq && !(n |= m.getKind() == TypeKind.NULL)) continue;
                    this.reportConstantAndLiteral(c1, c2);
                    return c1;
                }
                return null;
            }
        };
        if (!eval.process((TreePath)ctx.getVariables().get("$cond"))) {
            return null;
        }
        int minBranches = ctx.getPreferences().getInt(KEY_THRESHOLD, 3);
        if (eval.getNumberOfBranches() < minBranches) {
            return null;
        }
        if (eval.containsDuplicateConstants()) {
            ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>(eval.getDuplicateConstants().size());
            HashSet<String> seen = new HashSet<String>();
            for (Map.Entry<TreePath, Object> en : eval.getDuplicateConstants().entrySet()) {
                String lit = en.getValue().toString();
                if (!seen.add(lit)) continue;
                TreePath t = en.getKey();
                descs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)t, (String)Bundle.TEXT_ChainedIfContainsSameValues(lit), (Fix[])new Fix[0]));
            }
            return descs;
        }
        Fix convert = eval.createFix(NbBundle.getMessage(ConvertToStringSwitch.class, (String)"FIX_ConvertToStringSwitch"), ctx.getPreferences().getBoolean(OPTION_GENERATE_EMPTY_DEFAULT, true)).toEditorFix();
        ErrorDescription ed = ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_ConvertToSwitch(), (Fix[])new Fix[]{convert});
        return Collections.singletonList(ed);
    }

    private static TreePath isStringComparison(HintContext ctx, TreePath tp, boolean[] varConst, TreePath var) {
        Tree leaf = tp.getLeaf();
        while (leaf.getKind() == Tree.Kind.PARENTHESIZED) {
            tp = new TreePath(tp, ((ParenthesizedTree)leaf).getExpression());
            leaf = tp.getLeaf();
        }
        ArrayList<String> patterns = new ArrayList<String>(PATTERNS.length);
        patterns.addAll(Arrays.asList(PATTERNS));
        ctx.getVariables().put("$var", var);
        boolean acceptEqEq = ctx.getPreferences().getBoolean(KEY_ALSO_EQ, true);
        int i = -1;
        assert (PATTERNS.length == 6);
        for (String patt : patterns) {
            ++i;
            ctx.getVariables().remove("$constant");
            if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)tp, (String)patt, (boolean)true) || ctx.getVariables().get("$constant") == null || ctx.getVariables().get("$var") == null) continue;
            if (i % 2 == 0 && i < 4) {
                varConst[0] = true;
            }
            TreePath constPath = (TreePath)ctx.getVariables().get("$constant");
            if (i < 4 || acceptEqEq) {
                return constPath;
            }
            TypeMirror constType = ctx.getInfo().getTrees().getTypeMirror(constPath);
            if (constType == null || constType.getKind() != TypeKind.NULL) continue;
            return constPath;
        }
        return null;
    }
}

